import traceback

from fastapi import APIRouter, Depends

from scripts.constants import APIEndPoints
from scripts.core.handler import GraphTrackingHandler
from scripts.db import get_db
from scripts.logging import logger
from scripts.schemas import GraphData
from scripts.schemas.responses import DefaultFailureResponse, DefaultResponse

router = APIRouter(prefix=APIEndPoints.graph_base, tags=["Graph Traversal"])
genealogy_tracking_handler = GenealogyTrackingHandler()


@router.post(
    APIEndPoints.ingest_graph_data
)
def ingest_data_service(request_data: GraphData, db=Depends(get_db)):
    try:
        gth_obj = GraphTrackingHandler(db=db)
        data = gth_obj.ingest_data_handler(graph_data=request_data)
        return DefaultResponse(status="success", message="success", data=data)
    except Exception as e:
        tb = traceback.format_exc()
        logger.exception(e)
        logger.exception(tb)
        return DefaultFailureResponse(error=e.args).dict()
