if __name__ == '__main__':
    from dotenv import load_dotenv

    load_dotenv()
from scripts.core.engine import GraphTraversal
from scripts.db import get_db

from scripts.schemas import GraphData


def ingest_data_handler(graph_data: GraphData):
    try:
        node_list = []
        relations = []
        for node_type, node_obj in graph_data.__root__.items():
            db = get_db()

        print(node_list)
    except Exception as e:
        print(e.args)


input_data = {
    "Node1": {
        "node_id": "270120022",
        "action": "add",
        "node_name": "madhuri topu",
        "project_id": "madhuri's project",
        "node_label": "Event Label",
        "node_properties": {
            "name": "Event 1",
            "external_data_source": "mongo",
            "external_data_id": "101",
            "event_info": "847263",
            "received_date": 643308200,
            "completed_date": 1643394600
        },
        "edges": [],
        "tz": "Asia/Kolkata"
    },
    "Node2": {
        "node_id": "270120023",
        "node_label": "Event Label",
        "project_id": "madhuri's project",
        "action": "add",
        "node_name": "asjkfafjk",
        "node_properties": {
            "name": "Event 2",
            "external_data_source": "mongo",
            "external_data_id": "101",
            "event_info": "847263",
            "received_date": 643308200,
            "completed_date": 1643394600
        },
        "edges": [{
            "action": "add",
            "rel_name": "madhuri_don_boscho",
            "new_rel_name": "janu_s_UI",
            "bind_to": "Node1",
            "bind_id": "BSCH270120022"
        }]
    }
}
gt_obj = GraphTraversal(db=get_db())
GraphData(__root__=input_data)
gt_obj.ingest_data_handler(graph_data=GraphData(__root__=input_data))
