class InternalError(Exception):
    pass


class UnauthorizedError(Exception):
    pass


class ProjectIdError(Exception):
    pass


class ILensPermissionError(Exception):
    pass


class DuplicateTemplateNameError(Exception):
    pass


class DuplicateWorkflowNameError(Exception):
    pass


class ImplementationError(Exception):
    pass


class DuplicatestepNameError(Exception):
    pass


class StepNotFound(Exception):
    pass


class CustomError(Exception):
    pass


class DatetimeMismatchError(Exception):
    pass


class DuplicateLogbookNameError(Exception):
    pass


class FileExceptions(Exception):
    pass


class FileFormatNotSupported(FileExceptions):
    pass


class RequiredColumnsMissingException(Exception):
    pass


class FileNotFoundException(Exception):
    pass


class DisplayFieldsException(Exception):
    pass


class TaskCreationLimitExceeded(Exception):
    pass


class ILensErrors(Exception):
    def __init__(self, msg):
        Exception.__init__(self, msg)

    """
    Base Error Class
    """


class ErrorCodes:
    ERR001 = "ERR001 - Operating Time is greater than Planned Time"
    ERR002 = "ERR002 - Zero Values are not allowed"
    ERR003 = "ERR003 - Operating Time is less than Productive Time"
    ERR004 = "ERR004 - Rejected Units is greater than Total Units"


class DowntimeResponseError(ILensErrors):
    """
    Error Occurred during fetch of downtime
    """


class AuthenticationError(ILensErrors):
    """
    JWT Authentication Error
    """


class BulkUploadError(ILensErrors):
    """
        Bulk Upload Custom errors
    """


class CustomILensError(ILensErrors):
    """
        Bulk Upload Custom errors
    """


class NoPropertiesFound(ILensErrors):
    """
    No properties found for field even disable key is false
    """


class ErrorMessages:
    ERROR001 = "Authentication Failed. Please verify token"
    ERROR002 = "Signature Expired"
    ERROR003 = "Signature Not Valid"
