from gqlalchemy import Neo4j, Memgraph
from gqlalchemy.connection import Neo4jConnection

from scripts.config import DBConf
from scripts.logging import logger

host = DBConf.GRAPH_HOST
port = DBConf.GRAPH_PORT
username = DBConf.GRAPH_USERNAME
password = DBConf.GRAPH_PASSWORD


def db_func_mapper(conn_type):
    func_mapper = {
        "neo4j": Neo4j,
        "Neo4jConnection": Neo4jConnection,
        "memgraph": Memgraph
    }
    return func_mapper.get(conn_type)


def get_db(db_type=DBConf.GRAPH_DB_TYPE):
    connector = db_func_mapper(db_type)
    if connector is None:
        logger.exception(f"Connection Details not found for the selected database type -- {db_type}")
    return connector(host=host, username=username, password=password, port=port)
