if __name__ == '__main__':
    from dotenv import load_dotenv

    load_dotenv()
from scripts.core.engine import GraphTraversal
from scripts.db import get_db

from scripts.schemas import GraphData, GetNodeInfo


def ingest_data_handler(graph_data: GraphData):
    try:
        node_list = []
        relations = []
        for node_type, node_obj in graph_data.__root__.items():
            db = get_db()

        print(node_list)
    except Exception as e:
        print(e.args)


input_data = {
    "Node1": {
        "node_id": "event_1",
        "action": "add",
        "node_name": "Event 1",
        "project_id": "project_099",
        "node_type": "Events",
        "properties": {
            "name": "Event 1",
            "external_data_source": "mongo",
            "external_data_id": "101",
            "event_info": "847263",
            "received_date": 643308200,
            "completed_date": 1643394600
        },
        "edges": [],
        "tz": "Asia/Kolkata"
    },
    "Node2": {
        "node_id": "event_2",
        "project_id": "project_099",
        "action": "add",
        "node_name": "Event 2",
        "node_type": "Events,Harsha",
        "properties": {
            "name": "Event 2",
            "external_data_source": "mongo",
            "external_data_id": "101",
            "event_info": "847263",
            "received_date": 643308200,
            "completed_date": 1643394600
        },
        "edges": [{
            "action": "add",
            "rel_name": "Causes",
            "new_rel_name": "",
            "bind_to": "Node1",
            "bind_id": "BSCH270120022"
        }]
    },
    "Node3": {
        "node_id": "event_3",
        "action": "add",
        "node_name": "Event 3",
        "project_id": "project_099",
        "node_type": "Events",
        "properties": {
            "name": "Event 3",
            "external_data_source": "mongo",
            "external_data_id": "101",
            "event_info": "847263",
            "received_date": 643308200,
            "completed_date": 1643394600
        },
        "edges": [{
            "action": "add",
            "rel_name": "Error",
            "new_rel_name": "",
            "bind_to": "Node1",
            "bind_id": "BSCH270120022"
        }, {
            "action": "add",
            "rel_name": "Error2",
            "new_rel_name": "janu_s_UI",
            "bind_to": "Node2",
            "bind_id": "BSCH270120022"
        }],
        "tz": "Asia/Kolkata"
    }, "Node4": {
        "node_id": "event_4",
        "action": "add",
        "node_name": "Event 4",
        "project_id": "project_099",
        "node_type": "Events",
        "properties": {
            "name": "Event 4",
            "external_data_source": "mongo",
            "external_data_id": "101",
            "event_info": "847263",
            "received_date": 643308200,
            "completed_date": 1643394600
        },
        "edges": [{
            "action": "add",
            "rel_name": "Causes",
            "new_rel_name": "",
            "bind_to": "Node1",
            "bind_id": "BSCH270120022"
        }],
        "tz": "Asia/Kolkata"
    }

}
gt_obj = GraphTraversal(db=get_db())
GraphData(__root__=input_data)
# gt_obj.ingest_data_handler(graph_data=GraphData(__root__=input_data))
print(gt_obj.fetch_node_data(graph_request=GetNodeInfo(project_id="project_099",
                                                       node_id="event_1")))
