import os
import sys
from configparser import BasicInterpolation, ConfigParser


class EnvInterpolation(BasicInterpolation):
    """
    Interpolation which expands environment variables in values.
    """

    def before_get(self, parser, section, option, value, defaults):
        value = super().before_get(parser, section, option, value, defaults)

        if not os.path.expandvars(value).startswith('$'):
            return os.path.expandvars(value)
        else:
            return


try:
    config = ConfigParser(interpolation=EnvInterpolation())
    config.read(f"conf/application.conf")
except Exception as e:
    print(f"Error while loading the config: {e}")
    print("Failed to Load Configuration. Exiting!!!")
    sys.stdout.flush()
    sys.exit()


class Service:
    port = config["SERVICE"]["port"]
    host = config["SERVICE"]["host"]


class DBConf:
    DB_URI = config.get('SQL_DB', 'uri')
    if not DB_URI:
        print("Error, environment variable DB_URI not set")
        sys.exit(1)
    GRAPH_URI = config.get('GRAPH_DB', 'GRAPH_URI')
    GRAPH_USERNAME = config.get('GRAPH_DB', 'GRAPH_USERNAME')
    GRAPH_PASSWORD = config.get('GRAPH_CONN', 'GRAPH_PASSWORD')


class Logging:
    level = config.get("LOGGING", "level", fallback="DEBUG")
    level = level or "INFO"
    tb_flag = config.getboolean("LOGGING", "traceback", fallback=True)
    tb_flag = tb_flag if tb_flag is not None else True
