from edge_engine.common.logsetup import logger
from edge_engine.common.config import DEVICE_ID
from uuid import uuid4
import traceback
class FrameProcessor:
    def __init__(self, stream, model):
        self.model = model
        self.stream = stream
        logger.info("Setting up frame processor !!")

    def run_model(self):
        while self.stream.stream.isOpened():
            try:
                logger.debug("Getting frame mask_model")
                frame = self.stream.read()
                logger.debug("Running mask_model")
                data = {"frame": frame[0], "frameId":frame[1] , "deviceId": "{}".format(DEVICE_ID)}
                self.model.predict(data)
                logger.debug("publishing mask_model output")
            except Exception as e:
                logger.error(e)
                logger.error(traceback.format_exc())