from scripts.common.constants import JanusDeploymentConstants
from scripts.common.config import MONGO_DB_OBJ, APP_MONGO_COLLECTION


def get_extra_fields(device_id):
    _janus_deployment = MONGO_DB_OBJ[APP_MONGO_COLLECTION.get(JanusDeploymentConstants.JANUS_DEPLOYMENT_COLLECTION)]. \
            find_one({JanusDeploymentConstants.DEPLOYMENT_ID: device_id}).get(JanusDeploymentConstants.EXTRA_FIELDS_KEY)
    if _janus_deployment is None:
        raise ValueError("Janus deployment configuration is not found/corrupted")

    _key_dictionary = dict()
    for each_field in _janus_deployment:
        _key_dictionary[each_field['key']] = each_field['value']
    return _key_dictionary
