from fastapi import APIRouter
from scripts.logging.application_logging import logger
from scripts.core.handlers.user_management_handler import User_management as user_management_obj
from scripts.config.app_constants import Audit_user, Routes
from scripts.core.models.user_management_model import Login, GeneralProfileDetails, ChangePassword

router = APIRouter(prefix=Routes.user)


@router.post(Audit_user().list_audit_user, tags=[Routes.user])
def list_audit_user():
    try:
        logger.info("Inside list_audit_user service layer")
        response = user_management_obj.list_audit_users()
        return response
    except Exception as e:
        logger.error("Unable to list User" + str(e))


@router.post(Audit_user().login, tags=[Routes.user])
def login(req_json: Login):
    """

    :param req_json:
    :type req_json:
    :return:
    :rtype:
    """
    try:
        logger.info("inside login service layer")
        response = user_management_obj.login_page(req_json.user_id, req_json.password)
        return response
    except Exception as e:
        logger.error("Unable to login" + str(e))


@router.post(Audit_user().general_profile_info, tags=[Routes.user])
def general_profile_details(input_data: GeneralProfileDetails):
    try:
        logger.info("Inside profile details service layer")
        response = user_management_obj.general_profile_info(input_data)
        return response
    except Exception as e:
        logger.error("Unable to list User" + str(e))


@router.post(Audit_user().change_password, tags=[Routes.user])
def change_password(input_data: ChangePassword):
    try:
        logger.info("Inside change password service layer")
        response = user_management_obj.change_password(input_data)
        return response
    except Exception as e:
        logger.error("Unable to change password " + str(e))
