from scripts.logging.application_logging import logger
from scripts.utilities.mysql_utility import Utility
from scripts.config.app_constants import Table_headers, Response_message, Api_status

mysql_utility = Utility()
from datetime import datetime


class Leave_management:
    @staticmethod
    def leave_management_dashboard(user_id):
        """

        :param user_id:
        :type user_id:
        :return:
        :rtype:
        """
        try:
            response = dict()
            logger.info('Inside leave_management_dashboard handler')
            fetch_query = f"""select from_date, to_date, no_of_days, reason, applied_date, status from 
            leave_management where user_id = '{user_id}' """
            actual_data = mysql_utility.select_mysql_table(query=fetch_query)[1]
            response['status'] = Api_status.success
            response['message'] = Response_message.data_fetch
            response['data'] = dict()
            response['data']['header'] = Table_headers.leave_management
            response['data']['data'] = actual_data
            return response
        except Exception as e:
            logger.error("Unable to list leave details" + str(e))

    @staticmethod
    def audit_calender(user_id, start_date, end_date):
        """
        Function to show audit calender
        :param user_id:
        :type user_id:
        :return:
        :rtype:
        """
        try:
            response = dict()
            new_start_date = datetime.strptime(str(start_date), "%d/%m/%Y").strftime("%Y-%m-%d")
            new_end_date = datetime.strptime(str(end_date), "%d/%m/%Y").strftime("%Y-%m-%d")
            logger.info("Inside audit_calender dashboard")
            schedule_query = f"""select scheduled_start_date as start, scheduled_end_date as end, audit_name as title,
            company as companyName FROM audit where acknowledged_by = '{user_id}' and status = 'scheduled'
            and scheduled_start_date >= '{new_start_date}' and scheduled_end_date <= '{new_end_date}'"""
            scheduled_data = mysql_utility.select_mysql_table(query=schedule_query)[1]
            leave_query = f"""select from_date as start, to_date as end from leave_management 
            where user_id = '{user_id}'and from_date >= '{new_start_date}' and to_date <= '{new_end_date}' """
            leave_data = mysql_utility.select_mysql_table(query=leave_query)[1]
            scheduled = [dict(item, **{'color': '#B2EFD3', 'textColor': '#0D5130'}) for item in scheduled_data]
            leave = [dict(item, **{"color": "#B6CFF5", "title": "Leave", 'textColor': '#0F3573'}) for item in
                     leave_data]
            response['status'] = Api_status.success
            response['message'] = Response_message.data_fetch
            response['data'] = dict()
            response['data']['scheduled'] = scheduled
            response['data']['leave'] = leave
            return response
        except Exception as e:
            logger.error("Unable to fetch calender details" + str(e))

    @staticmethod
    def list_states(user_id):
        """

        Function to list states
        :return:
        :rtype:
        """
        try:
            response = dict()
            response['defaultState'] = ""
            logger.info("Inside list_states handler ")
            select_query = f"""select state_id as 'value', state_name as 'label' from states"""
            if user_id:
                default_state_query = f"""select location from audit_users where user_id = '{user_id}'"""
                default_state_data = mysql_utility.select_mysql_fetchone(query=default_state_query)[1]
                default_query = f"""select state_id from states where state_name = '{default_state_data.get('location', '')}'"""
                default_data = mysql_utility.select_mysql_fetchone(query=default_query)[1]
                if default_data is not None:
                    response['defaultState'] = default_data.get('state_id', '')
            states_data = mysql_utility.select_mysql_table(query=select_query)[1]
            response['status'] = Api_status.success
            response['message'] = Response_message.data_fetch
            response['data'] = states_data
            return response
        except Exception as e:
            logger.error("Unable to list states" + str(e))

    @staticmethod
    def list_holidays(req_json):
        """
        Function to list holidays as per state
        :param req_json:
        :type req_json:
        :return:
        :rtype:
        """
        try:
            response = dict()
            if req_json.state_id is None:
                default_state_query = f"""select location from audit_users where user_id = '{req_json.user_id}'"""
                default_state_data = mysql_utility.select_mysql_fetchone(query=default_state_query)[1]
                default_state = default_state_data.get('location', '')
                state_id_query = f"""select state_id from states where state_name = '{default_state}'"""
                state_data = mysql_utility.select_mysql_fetchone(query=state_id_query)[1]
                if state_data:
                    select_query = f"""select * from holiday where state_id = '{state_data.get('state_id', '')}'"""
            else:
                select_query = f"""select * from holiday where state_id = '{req_json.state_id}'"""
                state_name_query = f"""select state_name from states where state_id = '{req_json.state_id}'"""
                state_data = mysql_utility.select_mysql_fetchone(query=state_name_query)[1]
                default_state = state_data.get('state_name', '')
            actual_data = mysql_utility.select_mysql_table(query=select_query)[1]
            for each_data in actual_data:
                date = each_data.get('date', '')
                x = datetime.strptime(str(date), '%Y-%m-%d')
                new_date = x.strftime('%d-%b-%Y')
                each_data.update({'date': new_date, 'state': default_state})
            response['status'] = Api_status.success
            response['message'] = Response_message.data_fetch
            response['data'] = dict()
            response['data']['header'] = Table_headers.holiday_table_header
            response['data']['data'] = actual_data
            return response
        except Exception as e:
            logger.error("Unable to list holidays" + str(e))
