import uvicorn
from fastapi import FastAPI
from scripts.core.services import user_management_service, dashboard_service, leave_management_service, audit_service
from scripts.core.services.audit_service import audit_router
from scripts.logging.application_logging import logger


app = FastAPI(title="Epr 6")

app.include_router(user_management_service.router)
app.include_router(dashboard_service.router)
app.include_router(leave_management_service.router)
app.include_router(audit_router)

@app.get("/")
def read_root():
    return "welcome to the application"


if __name__ == "__main__":
    logger.info("EPR 6th module")
    uvicorn.run(app, host="localhost", port=5050)