
import pymysql

from scripts.logging.application_logging import logger
from scripts.config.app_configurations import MYSQL_HOST, MYSQL_USER, MYSQL_DB_NAME, MYSQL_DB_PASSWORD


class Utility(object):

    """
    Description: Constructor for the utility to initialize the variables used by the class

    Input:  host of the RDBMS database instance
            user of the RDBMS database
            password of the RDBMS database
            database name RDBMS database

    """
    def __init__(self):
        self.host = MYSQL_HOST
        self.user = MYSQL_USER
        self.password = MYSQL_DB_PASSWORD
        self.db_name = MYSQL_DB_NAME

    def update_mysql_table(self, query, data=[]):
        """
        This method is used for updating tables.

        :param query: The update query to be executed
        :return: status: The status True on success and False on failure
        """
        connection = None
        try:
            connection = pymysql.connect(host=self.host, user=self.user, password=self.password, db=self.db_name,
                                         charset='utf8mb4', cursorclass=pymysql.cursors.DictCursor)
            with connection.cursor() as cursor:
                cursor.execute(query,data)
            connection.commit()
            return True, "Success"
        except Exception as e:
            logger.error("Exception while updating: ", str(e))
            return False, str(e)
        finally:
            try:
                if connection is not None:
                    connection.close()
            except Exception as e:
                logger.error("Exception while closing connection: ", str(e))
                return False, str(e)

    def insert_mysql_table(self, query, data=[]):
        """
        This method is used for inserting new records in tables.

        :param query: The insert query to be executed
        :return: status: The status True on success and False on failure
        """
        connection = None
        try:
            connection = pymysql.connect(host=self.host, user=self.user, password=self.password, db=self.db_name,
                                         charset='utf8mb4', cursorclass=pymysql.cursors.DictCursor)
            with connection.cursor() as cursor:
                cursor.execute(query, data)
            connection.commit()
            return True, "Success"
        except Exception as e:
            logger.error("Exception while updating: ", str(e))
            return False, str(e)
        finally:
            try:
                if connection is not None:
                    connection.close()
            except Exception as e:
                logger.error("Exception while closing connection: ", str(e))
                return False, str(e)

    def insert_mysql_table_with_return(self, query, data=[]):
        """
        This method is used for inserting new records in tables.

        :param query: The insert query to be executed
        :return: status: The status True on success and False on failure
        """
        connection = None
        try:
            connection = pymysql.connect(host=self.host, user=self.user, password=self.password, db=self.db_name,
                                         charset='utf8mb4', cursorclass=pymysql.cursors.DictCursor)
            with connection.cursor() as cursor:
                # cursor.execute(query, data)
                test = cursor.execute(query, data)
                queryId = connection.insert_id()
            connection.commit()
            queryId1 = connection.insert_id()
            return True,queryId,"Success"
        except Exception as e:
            logger.error("Exception while updating: ", str(e))
            return False, str(e)
        finally:
            try:
                if connection is not None:
                    connection.close()
            except Exception as e:
                logger.error("Exception while closing connection: ", str(e))
                return False, str(e)

    def insert_many_mysql_table(self, query, data=[]):
        """
        This method is used for inserting new records in tables.

        :param query: The insert query to be executed
        :return: status: The status True on success and False on failure
        """
        connection = None
        try:

            connection = pymysql.connect(host=self.host, user=self.user, password=self.password, db=self.db_name,
                                         charset='utf8mb4', cursorclass=pymysql.cursors.DictCursor)
            with connection.cursor() as cursor:
                cursor.executemany(query, data)
            connection.commit()
            return True, "Success"
        except Exception as e:
            logger.error("Exception while updating: ", str(e))
            return False, str(e)
        finally:
            try:
                if connection is not None:
                    connection.close()
            except Exception as e:
                logger.error("Exception while closing connection: ", str(e))
                return False, str(e)

    def delete_mysql_table(self, query):
        """
        This method is used for updating tables.

        :param query: The update query to be executed
        :return: status: The status True on success and False on failure
        """
        connection = None
        try:
            connection = pymysql.connect(host=self.host, user=self.user, password=self.password, db=self.db_name,
                                         charset='utf8mb4', cursorclass=pymysql.cursors.DictCursor)
            with connection.cursor() as cursor:
                cursor.execute(query)
            connection.commit()
            return True, "Success"
        except Exception as e:
            logger.error("Exception while updating: ", str(e))
            return False, str(e)
        finally:
            try:
                if connection is not None:
                    connection.close()
            except Exception as e:
                logger.error("Exception while closing connection: ", str(e))
                return False, str(e)

    def select_mysql_table(self, query):
        """
        This method is used for selecting records from tables.

        :param query: The select query to be executed
        :return: status: The status True on success and False on failure and the list of rows
        """
        connection = None
        try:
            connection = pymysql.connect(host=self.host, user=self.user, password=self.password, db=self.db_name,
                                         charset='utf8mb4', cursorclass=pymysql.cursors.DictCursor)
            with connection.cursor() as cursor:
                cursor.execute(query)
                result = cursor.fetchall()
            return True, result
        except Exception as e:
            logger.error("Exception while updating: ", str(e))
            return False, str(e)
        finally:
            try:
                if connection is not None:
                    connection.close()
            except Exception as e:
                logger.error("Exception while closing connection: ", str(e))
                return False, str(e)

    def select_mysql_fetchone(self, query):
        """
        This method is used for selecting records from tables.

        :param query: The select query to be executed
        :return: status: The status True on success and False on failure and the list of rows
        """
        connection = None
        try:
            connection = pymysql.connect(host=self.host, user=self.user, password=self.password, db=self.db_name,
                                         charset='utf8mb4', cursorclass=pymysql.cursors.DictCursor)
            with connection.cursor() as cursor:
                cursor.execute(query)
                result = cursor.fetchone()
            return True, result
        except Exception as e:
            logger.error("Exception while updating: ", str(e))
            return False, str(e)
        finally:
            try:
                if connection is not None:
                    connection.close()
            except Exception as e:
                logger.error("Exception while closing connection: ", str(e))
                return False, str(e)