from fastapi import APIRouter
from scripts.logging.application_logging import logger
from scripts.core.handlers.leave_management_handler import Leave_management as leave_management_obj
from scripts.config.app_constants import Leave_management, Routes
from scripts.core.models.leave_management_model import Leave_dashboard, Audit_calender, Holiday_list, State_list

router = APIRouter(prefix=Routes.user)


@router.post(Leave_management().leave_dashboard, tags=[Routes.user])
def leave_management_dashboard(req_json: Leave_dashboard):
    """

    :param req_json:
    :type req_json:
    :return:
    :rtype:
    """
    try:
        logger.info("Inside leave_management_dashboard service")
        response = leave_management_obj.leave_management_dashboard(req_json.user_id)
        return response
    except Exception as e:
        logger.error("Unable to list User" + str(e))


@router.post(Leave_management().audit_calender, tags=[Routes.user])
def audit_calender(req_json: Audit_calender):
    """

    :param req_json:
    :type req_json:
    :return:
    :rtype:
    """
    try:
        logger.info("Inside audit_calender service")
        response = leave_management_obj.audit_calender(req_json.user_id, req_json.start, req_json.end)
        return response
    except Exception as e:
        logger.error("Unable to list User" + str(e))


@router.post(Leave_management().list_states, tags=[Routes.user])
def list_states(req_json: State_list):
    """
    Function to list states
    :return:
    :rtype:
    """
    try:
        logger.info("Inside list_states service")
        response = leave_management_obj.list_states(req_json.user_id)
        return response
    except Exception as e:
        logger.error("Unable to list User" + str(e))


@router.post(Leave_management().list_holidays, tags=[Routes.user])
def list_holidays(req_json: Holiday_list):
    """
    Function to list holidays
    :return:
    :rtype:
    """
    try:
        logger.info("Inside list_holidays service")
        response = leave_management_obj.list_holidays(req_json)
        return response
    except Exception as e:
        logger.error("Unable to list User" + str(e))
