from fastapi import APIRouter
from scripts.logging.application_logging import logger
from scripts.core.handlers.dashboard_handler import Dashboard as dashboard_obj
from scripts.config.app_constants import Dashboard, Routes
from scripts.core.models.dashboard_model import Schedule_audit, Dashboard_status_count, Dashboard_status_details, \
    Check_list_sidebar, Questions
router = APIRouter(prefix=Routes.user)


@router.post(Dashboard.dashboard_count, tags=[Routes.user])
def list_dashboard_status_count(req_json: Dashboard_status_count):
    """
    Function to list the count of dashboard
    :return:
    :rtype:
    """
    try:
        logger.info("Inside the list_dashboard_status_count service")
        response = dashboard_obj.list_dashboard_count(req_json.user_id)
        return response
    except Exception as e:
        logger.error("Unable to fetch the dashboard count" + str(e))


@router.post(Dashboard.fetch_status_details, tags=[Routes.user])
def fetch_dashboard_status_details(req_json: Dashboard_status_details):
    """
    Function to fetch individual status details
    :return:
    :rtype:
    """
    try:
        logger.info("Inside the fetch_dashboard_status_details service")
        response = dashboard_obj.fetch_status_details(req_json.user_id, req_json.status)
        return response
    except Exception as e:
        logger.error("Unable to fetch the dashboard status details" + str(e))


@router.post(Dashboard.schedule_audit, tags=[Routes.user])
def schedule_audit(req_json: Schedule_audit):
    """
    Function to Schedule Audit
    :return:
    :rtype:
    """
    try:
        logger.info("Inside the schedule_audit service")
        response = dashboard_obj.schedule_audit(req_json)
        return response
    except Exception as e:
        logger.error("Unable to schedule the audit" + str(e))


@router.post(Dashboard.check_list_sidebar, tags=[Routes.user])
def sidebar_check(req_json: Check_list_sidebar):
    """

    :param req_json:
    :type req_json:
    :return:
    :rtype:
    """
    try:
        logger.info("Inside the Start_audit Service")
        response = dashboard_obj.sidebar_check(req_json.audit_id)
        return response
    except Exception as e:
        logger.error("Unable to start the audit" + str(e))


@router.post(Dashboard.audit_questions, tags=[Routes.user])
def load_questions(req_json: Questions):
    """

    :param req_json:
    :type req_json:
    :return:
    :rtype:
    """
    try:
        logger.info("Inside the load_question Service")
        response = dashboard_obj.load_questions(req_json.section_id, req_json.audit_id)
        return response
    except Exception as e:
        logger.error("Unable to load the questions" + str(e))
