from typing import List

from fastapi import APIRouter, Form, UploadFile, File

from scripts.config.app_constants import Routes, Audit
from scripts.core.handlers.audit_handler import AuditHandler
from scripts.core.models.audit_model import SaveResponse, SubmitResponse

audit_router = APIRouter(prefix=Routes.audit)


@audit_router.post(Audit.save_response, tags=[Routes.audit])
def save_response(input_json:SaveResponse):
    try:
        final_json = AuditHandler().upload_response(input_json)
        return final_json

    except Exception as e:
        return False

@audit_router.post(Audit.submit_response, tags=[Routes.audit])
def save_response(input_json:SubmitResponse):
    try:
        final_json = AuditHandler().submit_response(input_json)
        return final_json

    except Exception as e:
        return False

