import json

from scripts.config.app_constants import ResponseMessage, Message
from scripts.core.handlers.dashboard_handler import mysql_utility
from scripts.logging.application_logging import logger


class AuditHandler:
    @staticmethod
    def upload_response(final_json):
        try:
            audit_id = final_json.audit_id
            section_id = final_json.section_id
            data = final_json.data
            for each in data:
                question_id = each['question_id']
                response = each['response']
                status = each['status']
                # notes = '{' + (', '.join('"' + item + '"' for item in each['notes'])) + '}'
                if each['notes'] == []:
                    note = {}
                else:
                    note = json.dumps(each['notes'])
                update_query = f"""update
                                    audit_question
                                set
                                    answer = '{str(response).replace("'", "''")}',
                                    note = '{note}',
                                    status = '{status}'
                                    where
                                    audit_id = '{audit_id}'AND
                                    section_id = '{section_id}'AND
                                    question_id = '{question_id}'
                                    """
                mysql_utility.update_mysql_table(query=update_query)

            return ResponseMessage.final_json(Message.success, "Successfully Saved")
        except Exception as e:
            logger.error("Exception while Uploading question response :" + str(e))
            return ResponseMessage.final_json(status=Message.failure, message="Error while Uploading question response")

    @staticmethod
    def submit_response(final_json):
        try:
            enable = final_json.enable
            audit_id = final_json.audit_id
            section_id = final_json.section_id
            data = final_json.data
            for each in data:
                question_id = each['question_id']
                response = each['response']
                status = each['status']
                # notes = '{' + (', '.join('"' + item + '"' for item in each['notes'])) + '}'
                if each['notes'] == []:
                    note = {}
                else:
                    note = json.dumps(each['notes'])
                update_query = f"""update
                                                audit_question
                                            set
                                                answer = '{str(response).replace("'", "''")}',
                                                note = '{note}',
                                                status = '{status}',
                                                enable = '{enable}'
                                                where
                                                audit_id = '{audit_id}'AND
                                                section_id = '{section_id}'AND
                                                question_id = '{question_id}'
                                                """
                print(update_query)
                mysql_utility.update_mysql_table(query=update_query)
            return ResponseMessage.final_json(Message.success, "Successfully Saved")
        except Exception as e:
            logger.error("Exception while Uploading question response :" + str(e))
            return ResponseMessage.final_json(status=Message.failure, message="Error while Uploading question response")


