class Base_url:
    base_url = "/api/v1.0/epr_audit"


class Audit_user:
    list_audit_user = '/list_audit_user'
    login = '/login'
    general_profile_info = '/general_profile_info'
    change_password = '/change_password'


class Dashboard:
    dashboard_count = '/list_dashboard_count'
    fetch_status_details = '/list_audit_status'
    schedule_audit = '/schedule_audit'
    check_list_sidebar = '/check_list_sidebar'
    audit_questions = '/audit_questions'

class Audit:
    save_response = '/save_response'
    submit_response = '/submit_response'

class Leave_management:
    leave_dashboard = '/leave_dashboard'
    audit_calender = '/audit_calender'
    list_states = '/list_states'
    list_holidays = '/list_holidays'


class Routes:
    user = Base_url.base_url + '/user'
    audit = Base_url.base_url + '/audit'


class Table_headers:
    list_users_header = [
        {
            "key": 'first_name',
            "value": 'First Name'
        },
        {
            "key": 'last_name',
            "value": 'Last Name'
        },
        {
            "key": 'ph_number',
            "value": 'Phone Number'
        },
        {
            "key": 'email',
            "value": 'Email Id'
        },
        {
            "key": 'user_id',
            "value": 'User Id'
        }
    ]
    status_details = [
        {
            "key": "audit_name",
            "value": "Audit Name"
        },
        {
            "key": "company",
            "value": "Company"
        },
        {
            "key": "address",
            "value": "Address"
        },
        {
            "key": "state",
            "value": "State"
        },
        {
            "key": "district",
            "value": "District"
        },
        {
            "key": "created_on",
            "value": "Created on"
        }
    ]
    progress_header = [
        {
            "key": "progress",
            "value": "Progress"
        }
    ]
    completed_header = [
        {
            "key": "status",
            "value": "Status"
        }
    ]
    leave_management = [
        {
            "key": "from_date",
            "value": "From"
        },
        {
            "key": "to_date",
            "value": "To"
        },
        {
            "key": "Days",
            "value": "no_of_days"
        },
        {
            "key": "Applied on",
            "value": "applied_date"
        },
        {
            "key": "Reason",
            "value": "reason"
        },
        {
            "key": "Status",
            "value": "status"
        }
    ]

    extra_headers = [{
        "key": "scheduled_start_date",
        "value": "Scheduled Start Date"
    },
        {
            "key": "scheduled_end_date",
            "value": "Scheduled End Date"
        }]
    holiday_table_header = [{
        "key": "date",
        "value": "Date"
    },

        {
            "key": "state",
            "value": "Location"
        },
        {
            "key": "holiday_name",
            "value": "Reason"
        },
        {
            "key": "day",
            "value": "Day"
        }]
    inbox_header = [
        {
            "key": "sender",
            "value": "Sender"
        },
        {
            "key": "Message",
            "value": "message"
        },
        {
            "key": "received_at",
            "value": "Received Time"
        }
    ]


class Table_constants:
    table_data = [
        {
            "key": "open",
            "label": "Open",
            "listType": "Open Audits Requests",
            "count": 0
        },
        {
            "key": "scheduled",
            "label": "Scheduled",
            "listType": "Scheduled Audits",
            "count": 0
        },
        {
            "key": "in_progress",
            "label": "In Progress",
            "listType": "Audits In-Progress",
            "count": 0
        },
        {
            "key": "completed",
            "label": "Completed",
            "listType": "Completed Audits",
            "count": 0
        }
    ]


class Response_message:
    data_fetch = "Data fetch Successful"
    login_success = "Login Successful"
    invalid_user = "Invalid Credentials"
    scheduled_successful = "Scheduled Successfully"
    schedule_exists = "Schedule Already Exists"
    response_submitted = "Response Submitted Successfully"


class Api_status:
    success = "Success"
    status_error = "error"
    warning = "warning"


class Boolean_keys:
    keys = [
        {
            'key': "yes",
            'label': "Yes"
        },
        {
            'key': "no",
            'label': "No"
        }
    ]

class ResponseMessage:
    @staticmethod
    def final_json(status, message, data=None):
        if data is not None:
            json = {"status": status, "message": message, "data": data}
        else:
            json = {"status": status, "message": message}
        return json


class Message:
    success = "Success"
    failure = "Failure"