import hashlib, uuid
from datetime import datetime, timedelta

import bcrypt
import re
from scripts.logging.application_logging import logger
from scripts.utilities.mysql_utility import Utility
from scripts.config.app_constants import Table_headers, Response_message, Api_status

mysql_utility = Utility()


class User_management:

    @staticmethod
    def list_audit_users():
        """
        Function to fetch all the audit users
        :return:
        :rtype:
        """
        try:
            response = dict()
            response['data'] = dict()
            logger.info("Inside list_audit_user handler function")
            fetch_query = f"""select first_name, last_name, user_id, ph_number, email from audit_users"""
            query_data = mysql_utility.select_mysql_table(query=fetch_query)
            response['status'] = Api_status.success
            response['message'] = Response_message.data_fetch
            response['data']['header'] = Table_headers.list_users_header
            response['data']['data'] = query_data[1]
            return response
        except Exception as e:
            logger.error("Unable to list user" + str(e))

    @staticmethod
    def login_page(user_id, password):
        """

        :param user_id:
        :type user_id:
        :param password:
        :type password:
        :return:
        :rtype:
        """
        try:
            response = dict()
            logger.info("Inside login_page function handler")
            fetch_query = f"""select first_name, last_name, password from audit_users where user_id = '{user_id}'"""
            actual_data = mysql_utility.select_mysql_table(query=fetch_query)[1]
            if bcrypt.checkpw(password.encode('ascii'), actual_data[0]['password'].encode('ascii')):
                response['status'] = Api_status.success
                response['message'] = Response_message.login_success
                response['user_id'] = user_id
                response['user_name'] = actual_data[0].get('first_name', '') + ' ' + actual_data[0].get('last_name', '')
            else:
                response['status'] = Api_status.status_error
                response['message'] = Response_message.invalid_user
            return response
        except Exception as e:
            logger.info("Unable to login" + str(e))

    @staticmethod
    def general_profile_info(input_data):
        """
        Function to fetch details of particular user
        :return:
        :rtype:
        """
        try:
            response = dict()
            response['data'] = dict()
            logger.info("Inside profile_details handler function")
            fetch_query = f"""select first_name,last_name,email,ph_number from audit_users where user_id = '{input_data.user_id}'"""
            query_data = mysql_utility.select_mysql_table(query=fetch_query)
            response['status'] = Api_status.success
            response['message'] = Response_message.data_fetch
            response['data']['data'] = query_data[1]
            return response
        except Exception as e:
            logger.error("Unable to list user" + str(e))

    @staticmethod
    def change_password(req_json):
        try:
            data = []
            response = dict()
            response['data'] = dict()
            if req_json.old_password is not None and len(req_json.old_password) > 0:
                select_query = f"""select first_name,password from audit_users where user_id = '{req_json.user_id}' """
                user = mysql_utility.select_mysql_table(query=select_query)
                print(user)
                if user is not None:
                    print(req_json.old_password.encode('ascii'))
                    print(user[1][0]['password'].encode('ascii'))
                    if bcrypt.checkpw(req_json.old_password.encode('ascii'), user[1][0]['password'].encode('ascii')):
                        if req_json.old_password != req_json.new_password:
                            if validate_password(req_json.new_password):
                                hashed_password = bcrypt.hashpw(req_json.new_password.encode(), bcrypt.gensalt())
                                hashed_password = hashed_password.decode('ascii')
                                update_query = f"""update audit_users 
                                       set password = '{hashed_password}'
                                       where user_id = '{req_json.user_id}'"""
                                status,result = mysql_utility.update_mysql_table(query=update_query)
                                if status:
                                    response['status'] = Api_status.success
                                    response['message'] = "The password is reset for " + str({req_json.user_id})
                                    response['data'] = data
                                    logger.info("Successfully updated the password")
                                    return response
                                else:
                                    logger.info("Failed to update the password in database")
                            else:
                                response['status'] = Api_status.status_error
                                response[
                                    'message'] = "New password should contain atleast 1 uppercase,1 lower case," \
                                                 "1 special character, 1 number and length should be bettween 8 and 16 "
                                return response
                        elif req_json.old_password == req_json.new_password:
                            response['status'] = Api_status.status_error
                            response[
                                'message'] = "Both new password and old password cannot be the same"
                            return response
                    else:
                        response['status'] = Api_status.status_error
                        response[
                            'message'] = "Incorrect old password. Please enter the correct old password"
                        return response
        except Exception as e:
            logger.error('exception at the reset password handler', e)
            raise Exception('Failed to reset password in  handler', e)


def validate_password(password):
    expression = '^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-9])(?=.*?[#?!@$%^&*-]).{8,}$'
    match_this = re.compile(expression)
    isvalid = re.search(match_this, password)
    if isvalid:
        return True
    else:
        return False
