import copy
import json
import uuid
from fastapi import Form, UploadFile, File
import ast
from scripts.logging.application_logging import logger
from scripts.utilities.mysql_utility import Utility
from scripts.config.app_constants import Table_constants, Response_message, Api_status, Table_headers, Boolean_keys
mysql_utility = Utility()


class Dashboard:

    @staticmethod
    def list_dashboard_count(user_id):
        """
        function to list the dashboard count
        :return:
        :rtype:
        """
        try:
            response = dict()
            logger.info("Inside list_dashboard_count handler")
            count_query = f"""select status, count(*) as count from audit where status in ('in_progress', 'scheduled', 
            'completed') AND acknowledged_by = '{user_id}' group by status UNION select status, COUNT(status) as 
            count from audit where status ='open' """
            data_count = mysql_utility.select_mysql_table(query=count_query)[1]
            for each_data in Table_constants.table_data:
                for new_data in data_count:
                    if each_data.get('key', '') == new_data.get('status', ''):
                        each_data.update({'count': new_data.get('count', 0)})
            response['status'] = Api_status.success
            response['message'] = Response_message.data_fetch
            response['data'] = Table_constants.table_data
            return response
        except Exception as e:
            logger.error("unable to fetch the dashboard count" + str(e))

    @staticmethod
    def fetch_status_details(user_id, application_status):
        """
        Function to fetch details according to status
        :return:
        :rtype:
        """
        try:
            response = dict()
            logger.info("Inside fetch_status_details service")
            status_details_table_header = copy.deepcopy(Table_headers.status_details)
            if application_status == 'scheduled':
                logger.info("Inside status: scheduled  if condition")
                query = f"""select audit_id, audit_name, company, address, state, district, scheduled_start_date, 
                scheduled_end_date, created_on  from audit 
                where status ='{application_status}' and acknowledged_by ='{user_id}' """
                status_details_table_header += Table_headers.extra_headers
            elif application_status == 'open':
                logger.info("Inside status: open if condition")
                query = f"""select audit_id, audit_name, company, address, state, district, created_on  from 
                                audit where status ='{application_status}'"""
            else:
                query = f"""select audit_id, audit_name, company, address, state, district, created_on  from 
                audit where status ='{application_status}' and acknowledged_by ='{user_id}' """

            actual_data = mysql_utility.select_mysql_table(query=query)[1]
            response_data = []
            if application_status == 'completed':
                status_details_table_header += Table_headers.completed_header
                for i in actual_data:
                    i.update({'status': 'Completed'})
                    response_data.append(i)

            if application_status == 'in_progress':
                for i in actual_data:
                    audit_id = i['audit_id']
                    count_total_question_query = f""" select count(*) as total_question from  audit_question 
                                    where audit_id = '{audit_id}'"""
                    count_total_question_data = mysql_utility.select_mysql_table(query=count_total_question_query)[1]
                    total_count_questions = count_total_question_data[0]['total_question']
                    count_question_answered_query = f""" select count(*) as question_answered 
                    from  audit_question where  status = 'in_progress' and audit_id = '{audit_id}' """
                    count_question_answered_data = mysql_utility.select_mysql_table(query=count_question_answered_query)[1]
                    count_question_answered = count_question_answered_data[0]['question_answered']

                    if total_count_questions == 0:
                        progress = 0
                    else:
                        progress = (count_question_answered / total_count_questions) * 100
                    i.update({'progress': int(progress)})
                    response_data.append(i)
                    status_details_table_header += Table_headers.progress_header

            response['data'] = dict()
            response['data']['header'] = status_details_table_header

            if application_status == 'in_progress' or application_status == 'completed':
                response['data']['data'] = response_data
            else:
                response['data']['data'] = actual_data

            response['status'] = Api_status.success
            response['message'] = Response_message.data_fetch

            return response
        except Exception as e:
            logger.error("Unable to fetch status details" + str(e))

    @staticmethod
    def schedule_audit(req_json):
        """

        :param req_json:
        :type req_json:
        :return:
        :rtype:
        """

        try:
            response = dict()
            logger.info('inside update_audit_status handler')
            validate_query = f"""select
    audit_name
from
    audit
where
    '{req_json.start_date}' <= scheduled_end_date
    and '{req_json.end_date}'>= scheduled_start_date
    and acknowledged_by = '{req_json.user_id}'
    and status = 'scheduled' """
            validation_data = mysql_utility.select_mysql_table(query=validate_query)[1]
            if validation_data:
                response['status'] = Api_status.warning
                response['message'] = Response_message.schedule_exists
                return response
            update_query = f"""update audit set scheduled_start_date = '{req_json.start_date}', 
            scheduled_end_date = '{req_json.end_date}',
             status = "scheduled", acknowledged_by = '{req_json.user_id}' where audit_id = '{req_json.audit_id}'"""
            mysql_utility.update_mysql_table(query=update_query)
            response['status'] = Api_status.success
            response['message'] = Response_message.scheduled_successful
            return response
        except Exception as e:
            logger.error('Unable to update the status' + str(e))

    @staticmethod
    def sidebar_check(audit_id):
        """
        :param audit_id:
        :type audit_id:
        :return:
        :rtype:
        """
        try:
            response = dict()
            logger.info("inside side_bar_check_list function handler")
            select_query = f"""select section_id as 'value', section_name as 'label' from section where audit_id =
            '{audit_id}'"""
            actual_data = mysql_utility.select_mysql_table(query=select_query)[1]
            print(actual_data)
            response['status'] = Api_status.success
            response['message'] = Response_message.scheduled_successful
            response['data'] = actual_data
            return response
        except Exception as e:
            logger.error("Unable to start the audit" + str(e))

    @staticmethod
    def load_questions(section_id, audit_id):
        """
        function to load questions to sections
        """
        try:
            response = dict()
            logger.info('inside load_questions handler')
            select_query = f"""select
                question_id,
                question,
                question_type,
                section_id,
                audit_id,
                options,
                note,
                status,
                answer,
                enable
                from audit_question where section_id = '{section_id}' and audit_id = '{audit_id}'"""
            actual_data = mysql_utility.select_mysql_table(query=select_query)[1]
            data = list()
            count = 1
            for each_data in actual_data:
                # print(str(each_data['options']))
                # options = list(json.dumps(each_data['options']))
                # print(options)
                # option =(json.loads(each_data['options']))
                # print(option)
                # options = str(json.dumps(each_data['options']))
                # for each in option2:
                #     print(each)
                question_id = each_data['question_id']
                status = each_data['status']
                question = each_data['question']
                answer = each_data['answer']
                notes = each_data['note']
                question_type = each_data['question_type']
                options = each_data['options']
                enable = each_data['enable']
                try:
                    options = ast.literal_eval(options)
                except:
                    options = []

                print(options)
                print(type(options))
                print(options)
                each_response = {
                    "qNo": count,
                    "question": question,
                    "status": status,
                    "response": answer,
                    "notes": [] if notes is None else json.loads(notes),
                    "question_id": question_id,
                    "inputType": question_type,
                    "options": options,
                    "enable": enable

                }
                # print(each_response)
                count = count + 1
                data.append(each_response)
            response['status'] = Api_status.success
            response['message'] = Response_message.data_fetch
            response['audit_id'] = audit_id
            response['section_id'] = section_id
            response['data'] = data
            return response
        except Exception as e:
            logger.error("Unable to load questions" + str(e))
            return str(e)

    @staticmethod
    def save_audit_response(req_json):
        """

        """
        try:
            logger.info('inside save_audit_response handler')
            response = dict()
            data = req_json.data
            for each_response in data:
                question_id = each_response.get('question_id', '')
                section_id = each_response.get('section_id', '')
                latest_response = each_response.get('answer', '')
                select_query = f"""select * from audit_response where question_id = '{question_id}' and section_id = 
                '{section_id}' and audit_id = '{req_json.audit_id}' """
                answer_data = mysql_utility.select_mysql_fetchone(query=select_query)[1]
                if answer_data is not None and latest_response != answer_data.get('answer', '') and \
                        each_response.get('notes', '') != answer_data.get('note', ''):
                    update_query = f"""update audit_response set answer = '{latest_response}'
                     , note = '{each_response.get('notes', '')}' 
                     where question_id = '{question_id}' and section_id = 
                    '{section_id}' and audit_id = '{req_json.audit_id}'"""
                    mysql_utility.update_mysql_table(query=update_query)
                else:
                    temp_id = uuid.uuid4().hex
                    insert_query = f"""INSERT INTO audit_response
                    (answer_id, answer, question_id, audit_id, note, status) 
                    VALUES
                    ('{temp_id}', '{latest_response}', '{question_id}', '{req_json.audit_id}', 
                    '{each_response.get('notes', '')}', 'completed')"""
                    mysql_utility.insert_mysql_table(query=insert_query)
            response['status'] = Api_status.success
            response['message'] = Response_message.response_submitted
            return response
        except Exception as e:
            logger.error("Unable to submit the response" + str(e))

    # @staticmethod
    # def inbox(user_id):
    #     """
    #
    #     """
    #     try:
    #         response = dict()
    #         logger.info("Inside inbox handler function")
    #         select_query = f"""select * from inbox where recipient = '{user_id}'"""
    #         inbox_data = mysql_utility.select_mysql_table(query=select_query)[1]
    #         for each_inbox
    #     except Exception as e:
    #         logger.error("Unable to load the inbox" + str(e))
