variable "aws_region" {
  description = "The AWS region to use to crwate resources."
  default     = "us-east-2"
}
variable "bucket_prefix" {
    type        = string
    description = "(required since we are not using 'bucket') Creates a unique bucket name begining with the specified prefix. Conflicts with bucket."
    default     = "my-s3bucket."
}
variable "tags" {
   type        =  map
   description = "(optional) A mapping of tags to assign to the bucket."
   default     = {
       environment = "DEV"
       terraform   = "true"
    }
}
variable "versioning" {
    type        = bool
    description = "(optional) A state of versioning."
    default     = true
}
variable "acl"{
    type        = string
    description = "Defaults to private "
    default     = "private"
}
