# Coding Standards for UnifyTwin

## Project Structure

```
my_sample_project
├── conf/
│   └── application.conf
├── scripts/
│   ├── services/
│   ├── core/
│   │   ├── handlers/
│   │   └── engine
│   ├── config/
│   ├── constants/
│   └── utils/
├── app.py
├── debug.py
├── .env
├── requirements.txt
├── README.md
├── variables.yml
└── Dockerfile
```

## Code Style

We adhere to the standards given in the [Google Style guide](https://google.github.io/styleguide/pyguide.html)
For Linting, `PyLint` is used.

## Modules to be used
- All services are written using [FastAPI](https://fastapi.tiangolo.com/)
- [Pymongo](https://pymongo.readthedocs.io/en/stable/) is preferred as mongo client. Should there be a need for Async, Motor can be used.
- [Mongo Utility](https://gitlab-pm.knowledgelens.com/KnowledgeLens/Products/iLens-2.0/platform-general/-/blob/master/mongo_util/mongo_util.py) is available for all UnifyTwin projects. It is strongly advised to use the util as it takes care of various standards we follow in UnifyTwin (DB split, security, etc).





