import logging
from enum import Enum

class UserManager(object):

    class User(Enum):
        """
        Define some default users.
        """
        Admin = 0
        Anonymous = 1
        User = 3

    def __init__(self, parent):
        self.logger = logging.getLogger(__name__)
        assert(hasattr(parent, 'private_key'))
        self._parent = parent
        self.user_manager = self.default_user_manager
        self.allow_remote_admin = True

    def default_user_manager(self, isession, userName, password):
        """
        Default user_manager, does nothing much but check for admin
        """
        if self.allow_remote_admin and userName in ("admin", "Admin"):
            isession.user = UserManager.User.Admin
        return True