import os
import sys
import traceback
import pandas as pd
import logging
from logging import StreamHandler

logger = logging.getLogger("YieldReport")
logger.setLevel(os.environ.get("logger", "INFO"))
__formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(module)s - %(lineno)d - %(message)s')
__console_handler = StreamHandler(sys.stdout)
__console_handler.setFormatter(__formatter)
logger.addHandler(__console_handler)
enable_traceback = True


class AppConstants(object):
    """
    In this Constants class we will be having the new column names and the dependant column names
    """
    fresh_7302011030 = {
        "new_column": "Fresh 7302011030",
        "dependant_column": "7302011030"
    }
    totaliser_7302011030 = {
        "new_column": "7302011030 totaliser",
        "dependant_column": "Main 7302011030 Totaliser"
    }
    calculated_7303011675 = {
        "new_column": "Calculated 7303011675",
        "dependant_column": "7303011675",
        "condition": [0, 100000]
    }
    calculated_IV_component = {
        "new_column": "Calculated IV component",
        "dependant_column": "IV component"
    }
    calculated_E5E014_E5E003_E5E016 = {
        "new_column": "Calculated E5E014,E5E003, E5E016",
        "dependant_column": "E5E014,E5E003, E5E016"
    }
    total_7302011030 = {
        "new_column": "TOTAL 7302011030",
        "dependant_column": "Recovered 7302011030"
    }
    fresh_div_total_7302011030 = {
        "new_column": "Fresh 7302011030 / Total 7302011030",
        "numerator": "Fresh 7302011030",
        "denominator": "TOTAL 7302011030"
    }
    A1A023_A1A024 = {
        "new_column": "Calculated A1A023, A1A024",
        "dependant_column": "A1A023, A1A024",
        "condition": [0, 100000]
    }

    A1A023_A1A024_plus_7303011675_plus_IV_component = {
        "new_column": "(A1A023, A1A024)+7303011675+IV component",
        "dependant_column": ["Calculated A1A023, A1A024", "Calculated 7303011675", "Calculated IV component"]
    }

    PRODN_RXNPDT = {
        "new_column": "PRODN. RXN PDT",
        "dependant_column": "Reaction Product ",
        "condition": [0, 100000]
    }

    Calculated_Scrubber = {
        "new_column": "Calculated Scrubber",
        "dependant_column_1": "Package Scrubber Over Flow ",
        "condition_1": [0, 1000000],
        "dependant_column_2": "Package Scrubber Make Up ",
        "condition_2": [0, 1000000]

    }

    Calculated_MEE_to_RPT = {
        "new_column": "Calculated MEE To RPT",
        "dependant_column": "MEE To RPT",
        "condition": [0, 1000000]
    }
    surge_tank_total = {
        "new_column": "Surge Tank (PB) Total",
        "dependant_column": ["Surge Tank Pyr", "Surge Tank Beta"]
    }
    make_up_to_mee_tank = {
        "new_column": "Make Up To P/S  (PB) MEE Tank",
        "dependant_column": ["Make Up To P/S (Pyr) MEE Tank", "Make Up To P/S (Beta) MEE Tank"]
    }
    norm_surge_tank_stage = {
        "new_column": "Norm (Surge Tank Stage)",
        "dependant_column": ["(A1A023, A1A024)+7303011675+IV component", "PRODN. RXN PDT", "Surge Tank (PB) Total"]
    }
    norm_rpt_stage = {
        "new_column": "Norm (RPT Stage)",
        "dependant_column": ["(A1A023, A1A024)+7303011675+IV component", "PRODN. RXN PDT", "Surge Tank (PB) Total",
                             "Calculated MEE To RPT", "Make Up To P/S  (PB) MEE Tank"]
    }
    calculate_yield = {
        "new_column": "Yield",
        "dependant_column": ["PRODN. RXN PDT", "Calculated A1A023, A1A024", "Calculated E5E014,E5E003, E5E016",
                             "TOTAL 7302011030"]
    }
    A1A023_A1A024_to_E5E014_E5E003_E5E016_Molar_ratio = {
        "new_column": "A1A023, A1A024 to E5E014 E5E003 E5E016 Molar ratio",
        "dependant_column": ["Calculated E5E014,E5E003, E5E016", "E5E014 E5E003 E5E016 Conc Shift Average",
                             "Calculated A1A023, A1A024"],
        "constants": [44, 30]
    }
    A1A023_A1A024_to_Amm_Molar_ratio = {
        "new_column": "A1A023, A1A024 to Amm Molar ratio",
        "dependant_column": ["TOTAL 7302011030", "Fresh 7302011030", "Calculated A1A023, A1A024"],
        "constants": [0.75, 44, 17]
    }

    E5E014_E5E003_E5E016_to_A1A023_A1A024_ratio_37 = {
        "new_column": "E5E014 E5E003 E5E016 to A1A023, A1A024 ratio @ 37%",
        "dependant_column": ["Calculated E5E014,E5E003, E5E016", "Calculated A1A023, A1A024",
                             "E5E014 E5E003 E5E016 Conc Shift Average"],
        "constants": [37]
    }

    PB_From_Surge_Tank = {
        "new_column": "PB From Surge Tank",
        "dependant_column": ["PRODN. RXN PDT", "Surge Tank (PB) Total"]
    }

    fresh_7302011030_div_A1A023_A1A024_feed = {
        "new_column": "fresh 7302011030/A1A023, A1A024 feed",
        "dependant_column": ["Fresh 7302011030", "(A1A023, A1A024)+7303011675+IV component"]
    }
    Total_Amm_A1A023_A1A024_feed = {
        "new_column": "Total Amm / A1A023, A1A024 feed",
        "dependant_column": ["TOTAL 7302011030", "(A1A023, A1A024)+7303011675+IV component"]
    }
    Surge_tk_Pyr_ratio = {
        "new_column": "Surge tk Pyr ratio",
        "dependant_column": ["Surge Tank Pyr", "Surge Tank (PB) Total"]
    }
    Package_Makeup = {
        "new_column": "Package Makeup",
        "dependant_column": ["Calculated MEE To RPT", "MEE To RPT"],
        "condition": [0, 100000]
    }
    Package_Overflow = {
        "new_column": "Package Overflow",
        "dependant_column": "Package Scrubber Over Flow ",
        "condition": [0, 1000000]
    }
    Rec_from_package_Pyr = {
        "new_column": "Rec from package Pyr",
        "dependant_column": ["Package Overflow", "Package OF Pyr", "Make Up To P/S (Pyr) MEE Tank", "Package Makeup"]
    }
    Rec_from_package_Beta = {
        "new_column": "Rec from package Beta",
        "dependant_column": ["Package Overflow", "Package OF Beta", "Make Up To P/S (Beta) MEE Tank", "Package Makeup"]
    }

    Package_OF_PB = {
        "new_column": "Package OF PB",
        "dependant_column": ["Package OF Pyr", "Package OF Beta"]
    }

    PB_from_Pkg = {
        "new_column": "PB from Pkg",
        "dependant_column": ["Package Overflow", "Package OF PB", "Package Makeup", "Make Up To P/S  (PB) MEE Tank"]
    }
    NET_RECOVERED_PB = {
        "new_column": "NET RECOVERED PB",
        "dependant_column": ["PB From Surge Tank", "PB from Pkg"]
    }
    A1A023_A1A024_NORM_div_SHIFT = {
        "new_column": "A1A023, A1A024 NORM /SHIFT",
        "dependant_column": ["Calculated A1A023, A1A024", "NET RECOVERED PB"]
    }
    Pyridine_ratio_Nett = {
        "new_column": "Pyridine ratio Nett",
        "dependant_column": ["Surge Tank Pyr", "PRODN. RXN PDT", "Package Overflow", "Package OF Pyr",
                             "Make Up To P/S (Pyr) MEE Tank", "Package Makeup", "NET RECOVERED PB"]
    }

    Pkg_Pyr_ratio = {
        "new_column": "Pkg Pyr ratio",
        "dependant_column": ["Package Overflow", "Package OF Pyr", "Make Up To P/S (Pyr) MEE Tank", "Package Makeup",
                             "PB from Pkg"]
    }
    Beta_ratio_Nett = {
        "new_column": "Beta ratio Nett",
        "dependant_column": ["Surge Tank Pyr", "PRODN. RXN PDT", "Package Overflow", "Package OF Pyr",
                             "Make Up To P/S (Pyr) MEE Tank", "Package Makeup", "NET RECOVERED PB"]
    }
    Pyridine_ratio_Nett_including_Common_scrubber = {
        "new_column": "Pyridine ratio Nett including Common scrubber",
        "dependant_column": ["Surge Tank Pyr", "PRODN. RXN PDT", "Package Overflow", "Package OF Pyr",
                             "Make Up To P/S (Pyr) MEE Tank", "Package Makeup", "NET RECOVERED PB"],
        "constants": 150
    }
    cal_24_hr_A1A023_A1A024_LOAD = {
        "new_column": "24 hr A1A023, A1A024 LOAD (Kg/hr)",
        "dependant_column": ["Date", "Calculated A1A023, A1A024"],
        "constants": 3
    }


class CalculatedColumns:
    def fresh_7302011030(self, df):
        my_dict = AppConstants.fresh_7302011030
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            df[my_dict['new_column']] = df[my_dict['dependant_column']].diff()
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def totaliser_7302011030(self, df):
        my_dict = AppConstants.totaliser_7302011030
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            df[my_dict['new_column']] = df[my_dict['dependant_column']].diff()
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def calculated_7303011675(self, df):
        # check negative
        my_dict = AppConstants.calculated_7303011675
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            df[my_dict['new_column']] = df[my_dict['dependant_column']].diff()
            my_list = list(df[my_dict['new_column']])
            new_list = []
            for i in my_list:
                if i > 0:
                    new_list.append(i + my_dict['condition'][0])
                elif i < 0:
                    new_list.append(i + my_dict['condition'][1])
                else:
                    new_list.append(i)
            df[my_dict['new_column']] = pd.Series(new_list)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def calculated_IV_component(self, df):
        my_dict = AppConstants.calculated_IV_component
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            df[my_dict['new_column']] = df[my_dict['dependant_column']].diff()
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def calculated_E5E014_E5E003_E5E016(self, df):
        my_dict = AppConstants.calculated_E5E014_E5E003_E5E016
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            df[my_dict['new_column']] = df[my_dict['dependant_column']].diff()
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def total_7302011030(self, df):
        my_dict = AppConstants.total_7302011030
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            df[my_dict['new_column']] = df[my_dict['dependant_column']].diff()
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def fresh_div_total_7302011030(self, df):
        my_dict = AppConstants.fresh_div_total_7302011030
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            df[my_dict['new_column']] = ((df[my_dict['numerator']] / df[my_dict['denominator']]) * 100)
            my_list = list(df[my_dict['new_column']])
            new_list = []
            for i in my_list:
                if i > 0:
                    new_list.append(str(round(i, 2)) + "%")
                else:
                    new_list.append(i)
            df[my_dict['new_column']] = pd.Series(new_list)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def A1A023_A1A024(self, df):
        my_dict = AppConstants.A1A023_A1A024
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            df[my_dict['new_column']] = df[my_dict['dependant_column']].diff()
            my_list = list(df[my_dict['new_column']])
            new_list = []
            for i in my_list:
                if i > 0:
                    new_list.append(i + my_dict['condition'][0])
                elif i < 0:
                    new_list.append(i + my_dict['condition'][1])
                else:
                    new_list.append(i)
            df[my_dict['new_column']] = pd.Series(new_list)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def A1A023_A1A024_plus_7303011675_plus_IV_component(self, df):
        my_dict = AppConstants.A1A023_A1A024_plus_7303011675_plus_IV_component
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            df[my_dict['new_column']] = df[my_dict['dependant_column'][0]] + df[my_dict['dependant_column'][1]] + df[
                my_dict['dependant_column'][2]]
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def PRODN_RXNPDT(self, df):
        my_dict = AppConstants.PRODN_RXNPDT
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            df[my_dict['new_column']] = df[my_dict['dependant_column']].diff()
            my_list = list(df[my_dict['new_column']])
            new_list = []
            for i in my_list:
                if i > 0:
                    new_list.append(i + my_dict['condition'][0])
                elif i < 0:
                    new_list.append(i + my_dict['condition'][1])
                else:
                    new_list.append(i)
            df[my_dict['new_column']] = pd.Series(new_list)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def Calculated_Scrubber(self, df):
        my_dict = AppConstants.Calculated_Scrubber
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            df["temp1"] = df[my_dict['dependant_column_1']].diff()
            df["temp2"] = df[my_dict['dependant_column_2']].diff()
            df[my_dict['new_column']] = df["temp1"] - df["temp2"]
            final_list = list(df[my_dict['new_column']])
            my_list = list(df["temp1"])
            print(my_list)
            new_list = []
            for i in range(0, len(my_list)):
                if my_list[i] > 0:
                    new_list.append(final_list[i] + my_dict['condition_1'][0])
                elif my_list[i] < 0:
                    new_list.append(final_list[i] + my_dict['condition_1'][1])
                else:
                    new_list.append(final_list[i])
            df["temp1"] = pd.Series(new_list)
            print(new_list)
            my_list_1 = list(df["temp2"])
            new_list_1 = []
            print(my_list_1)
            for i in range(0, len(my_list_1)):
                if my_list_1[i] > 0:
                    new_list_1.append(new_list[i] + my_dict['condition_2'][0])
                elif my_list_1[i] < 0:
                    new_list_1.append(new_list[i] + my_dict['condition_2'][1])
                else:
                    new_list_1.append(new_list[i])
            df["temp2"] = pd.Series(new_list_1)
            df[my_dict['new_column']] = pd.Series(new_list_1)
            df = df.drop(["temp1", "temp2"], axis=1)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def Calculated_MEE_to_RPT(self, df):
        my_dict = AppConstants.Calculated_MEE_to_RPT
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            df[my_dict['new_column']] = df[my_dict['dependant_column']].diff()
            my_list = list(df[my_dict['new_column']])
            new_list = []
            for i in my_list:
                if i > 0:
                    new_list.append(i + my_dict['condition'][0])
                elif i < 0:
                    new_list.append(i + my_dict['condition'][1])
                else:
                    new_list.append(i)
            df[my_dict['new_column']] = pd.Series(new_list)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def surge_tank_total(self, df):
        my_dict = AppConstants.surge_tank_total
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            df[my_dict['new_column']] = df[my_dict['dependant_column'][0]] + df[my_dict['dependant_column'][1]]
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def make_up_to_mee_tank(self, df):
        my_dict = AppConstants.make_up_to_mee_tank
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            df[my_dict['new_column']] = round(df[my_dict['dependant_column'][0]] + df[my_dict['dependant_column'][1]],
                                              2)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def norm_surge_tank_stage(self, df):
        my_dict = AppConstants.norm_surge_tank_stage
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            df[my_dict['new_column']] = round((df[my_dict['dependant_column'][0]]) / (
                    (df[my_dict['dependant_column'][1]] * df[my_dict['dependant_column'][2]]) / 100), 3)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def norm_rpt_stage(self, df):
        my_dict = AppConstants.norm_rpt_stage
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            df[my_dict['new_column']] = round((df[my_dict['dependant_column'][0]]) /
                                              ((df[my_dict['dependant_column'][1]] * df[
                                                  my_dict['dependant_column'][2]]) / 100 + (
                                                       df[my_dict['dependant_column'][3]] * df[
                                                   my_dict['dependant_column'][4]]) / 100), 3)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def calculate_yield(self, df):
        my_dict = AppConstants.calculate_yield
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            df[my_dict['new_column']] = round((df[my_dict['dependant_column'][0]] / (
                    df[my_dict['dependant_column'][1]] + df[my_dict['dependant_column'][2]] + df[
                my_dict['dependant_column'][3]])) * 100, 2)
            my_list = list(df[my_dict['new_column']])
            new_list = []
            for i in my_list:
                if i > 0:
                    new_list.append(str(i) + "%")
                else:
                    new_list.append(i)
            df[my_dict['new_column']] = pd.Series(new_list)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def A1A023_A1A024_to_E5E014_E5E003_E5E016_Molar_ratio(self, df):
        my_dict = AppConstants.A1A023_A1A024_to_E5E014_E5E003_E5E016_Molar_ratio
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            df[my_dict['new_column']] = (df[my_dict['dependant_column'][0]] * df[my_dict['dependant_column'][1]] *
                                         my_dict['constants'][0]) / (
                                                df[my_dict['dependant_column'][2]] * my_dict['constants'][1]) / 100
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def A1A023_A1A024_to_Amm_Molar_ratio(self, df):
        my_dict = AppConstants.A1A023_A1A024_to_Amm_Molar_ratio
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            nr = ((df[my_dict['dependant_column'][0]] - df[my_dict['dependant_column'][1]]) * my_dict['constants'][0]) + \
                 df[my_dict['dependant_column'][1]]
            df[my_dict['new_column']] = round(
                (nr * my_dict['constants'][1]) / (df[my_dict['dependant_column'][2]] * my_dict['constants'][2]), 2)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def E5E014_E5E003_E5E016_to_A1A023_A1A024_ratio_37(self, df):
        my_dict = AppConstants.E5E014_E5E003_E5E016_to_A1A023_A1A024_ratio_37
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            nr = ((df[my_dict['dependant_column'][0]]) / df[my_dict['dependant_column'][1]]) * df[
                my_dict['dependant_column'][2]]
            df[my_dict['new_column']] = nr / my_dict['constants'][0]
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def PB_From_Surge_Tank(self, df):
        my_dict = AppConstants.PB_From_Surge_Tank
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            nr = (df[my_dict['dependant_column'][0]] * df[my_dict['dependant_column'][1]]) / 100
            df[my_dict['new_column']] = round(nr, 3)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def fresh_7302011030_div_A1A023_A1A024_feed(self, df):
        my_dict = AppConstants.fresh_7302011030_div_A1A023_A1A024_feed
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            nr = (df[my_dict['dependant_column'][0]] / df[my_dict['dependant_column'][1]])
            df[my_dict['new_column']] = round(nr, 3)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def Total_Amm_A1A023_A1A024_feed(self, df):
        my_dict = AppConstants.Total_Amm_A1A023_A1A024_feed
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            nr = (df[my_dict['dependant_column'][0]] / df[my_dict['dependant_column'][1]])
            df[my_dict['new_column']] = round(nr, 3)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def Surge_tk_Pyr_ratio(self, df):
        my_dict = AppConstants.Surge_tk_Pyr_ratio
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            nr = (df[my_dict['dependant_column'][0]] / df[my_dict['dependant_column'][1]])
            df[my_dict['new_column']] = round(nr, 3)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def Package_Makeup(self, df):
        my_dict = AppConstants.Package_Makeup
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            df['temp'] = df[my_dict['dependant_column'][1]].diff()
            my_list = list(df['temp'])
            print(my_list)
            new_list = []
            for i in my_list:
                if i > 0:
                    new_list.append(i + my_dict['condition'][0])
                elif i < 0:
                    new_list.append(i + my_dict['condition'][1])
                else:
                    new_list.append(i)
            print(new_list)
            print(list(df[my_dict['dependant_column'][0]]))
            df['temp'] = pd.Series(new_list)
            df[my_dict['new_column']] = df['temp'] + df[my_dict['dependant_column'][0]]
            df = df.drop(["temp"], axis=1)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}",
                         exc_info=enable_traceback)

    def Package_Overflow(self, df):
        my_dict = AppConstants.Package_Overflow
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            df[my_dict['new_column']] = df[my_dict['dependant_column']].diff()
            my_list = list(df[my_dict['new_column']])
            new_list = []
            for i in my_list:
                if i > 0:
                    new_list.append(i + my_dict['condition'][0])
                elif i < 0:
                    new_list.append(i + my_dict['condition'][1])
                else:
                    new_list.append(i)
            df[my_dict['new_column']] = pd.Series(new_list)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def Rec_from_package_Pyr(self, df):
        my_dict = AppConstants.Rec_from_package_Pyr
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            nr = (df[my_dict['dependant_column'][0]] * df[my_dict['dependant_column'][1]]) / 100
            dr = (df[my_dict['dependant_column'][2]] * df[my_dict['dependant_column'][3]]) / 100
            df[my_dict['new_column']] = round(nr - dr, 3)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def Rec_from_package_Beta(self, df):
        my_dict = AppConstants.Rec_from_package_Beta
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            nr = (df[my_dict['dependant_column'][0]] * df[my_dict['dependant_column'][1]]) / 100
            dr = (df[my_dict['dependant_column'][2]] * df[my_dict['dependant_column'][3]]) / 100
            df[my_dict['new_column']] = round(nr - dr, 1)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def Package_OF_PB(self, df):
        my_dict = AppConstants.Package_OF_PB
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            nr = (df[my_dict['dependant_column'][0]] + df[my_dict['dependant_column'][1]])
            df[my_dict['new_column']] = round(nr, 2)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def PB_from_Pkg(self, df):
        my_dict = AppConstants.PB_from_Pkg
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            nr = (df[my_dict['dependant_column'][0]] * df[my_dict['dependant_column'][1]])
            dr = (df[my_dict['dependant_column'][2]] * df[my_dict['dependant_column'][3]])
            df[my_dict['new_column']] = round((nr - dr) / 100, 0)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def NET_RECOVERED_PB(self, df):
        my_dict = AppConstants.NET_RECOVERED_PB
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            nr = (df[my_dict['dependant_column'][0]] + df[my_dict['dependant_column'][1]])
            df[my_dict['new_column']] = round(nr, 0)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def A1A023_A1A024_NORM_div_SHIFT(self, df):
        my_dict = AppConstants.A1A023_A1A024_NORM_div_SHIFT
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            nr = (df[my_dict['dependant_column'][0]] / df[my_dict['dependant_column'][1]])
            df[my_dict['new_column']] = round(nr, 3)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def Pyridine_ratio_Nett(self, df):
        my_dict = AppConstants.Pyridine_ratio_Nett
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            nr = (df[my_dict['dependant_column'][0]] * df[my_dict['dependant_column'][1]]) / 100
            nr2 = (df[my_dict['dependant_column'][2]] * df[my_dict['dependant_column'][3]]) / 100
            nr3 = df[my_dict['dependant_column'][4]] * df[my_dict['dependant_column'][5]] / 100
            df[my_dict['new_column']] = round(100 * ((nr + (nr2 - nr3)) / df[my_dict['dependant_column'][6]]), 2)
            my_list = list(df[my_dict['new_column']])
            new_list = []
            for i in my_list:
                if i > 0:
                    new_list.append(str(i) + "%")
                else:
                    new_list.append(i)
            df[my_dict['new_column']] = pd.Series(new_list)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def Pkg_Pyr_ratio(self, df):
        my_dict = AppConstants.Pkg_Pyr_ratio
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            nr = (df[my_dict['dependant_column'][0]] * df[my_dict['dependant_column'][1]]) / 100
            nr2 = (df[my_dict['dependant_column'][2]] * df[my_dict['dependant_column'][3]]) / 100
            df[my_dict['new_column']] = round(100 * ((nr - nr2) / df[my_dict['dependant_column'][4]]), 0)
            my_list = list(df[my_dict['new_column']])
            new_list = []
            for i in my_list:
                if i > 0:
                    new_list.append(str(i) + "%")
                else:
                    new_list.append(i)
            df[my_dict['new_column']] = pd.Series(new_list)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def Beta_ratio_Nett(self, df):
        my_dict = AppConstants.Beta_ratio_Nett
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            nr = (df[my_dict['dependant_column'][0]] * df[my_dict['dependant_column'][1]]) / 100
            nr2 = (df[my_dict['dependant_column'][2]] * df[my_dict['dependant_column'][3]]) / 100
            nr3 = df[my_dict['dependant_column'][4]] * df[my_dict['dependant_column'][5]] / 100
            df[my_dict['new_column']] = 100 - round(100 * ((nr + (nr2 - nr3)) / df[my_dict['dependant_column'][6]]), 2)
            my_list = list(df[my_dict['new_column']])
            new_list = []
            for i in my_list:
                if i > 0:
                    new_list.append(str(i) + "%")
                else:
                    new_list.append(i)
            df[my_dict['new_column']] = pd.Series(new_list)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def Pyridine_ratio_Nett_including_Common_scrubber(self, df):
        my_dict = AppConstants.Pyridine_ratio_Nett_including_Common_scrubber
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            nr = (df[my_dict['dependant_column'][0]] * df[my_dict['dependant_column'][1]]) / 100
            nr2 = (df[my_dict['dependant_column'][2]] * df[my_dict['dependant_column'][3]]) / 100
            nr3 = df[my_dict['dependant_column'][4]] * df[my_dict['dependant_column'][5]] / 100
            df[my_dict['new_column']] = round(
                100 * ((nr + (nr2 - nr3) + my_dict['constants']) / df[my_dict['dependant_column'][6]]), 2)
            my_list = list(df[my_dict['new_column']])
            new_list = []
            for i in my_list:
                if i > 0:
                    new_list.append(str(i) + "%")
                else:
                    new_list.append(i)
            df[my_dict['new_column']] = pd.Series(new_list)
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)

    def cal_24_hr_A1A023_A1A024_LOAD(self, df):
        my_dict = AppConstants.cal_24_hr_A1A023_A1A024_LOAD
        try:
            logger.info(f"Calculating the column {my_dict['new_column']}")
            date_list = list(df[my_dict['dependant_column'][0]])
            my_list = list(df[my_dict['dependant_column'][1]])
            df2 = pd.DataFrame()
            df2['Date'] = pd.Series(date_list)
            df2[my_dict['new_column']] = pd.Series(my_list)
            df2 = df2.groupby(df2['Date']).sum()
            df2[my_dict['new_column']] = round(df2[my_dict['new_column']]/3,3)
            df = pd.merge(df, df2, how='left', on=['Date'])
            return df
        except Exception as e:
            logger.error(f"Failed to calculate {my_dict['new_column']} because of error {e}", exc_info=enable_traceback)
