import os
import sys
import traceback
import pandas as pd
import logging
from logging import StreamHandler

logger = logging.getLogger("YieldReport-Parser")
logger.setLevel(os.environ.get("logger", "INFO"))
__formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(module)s - %(lineno)d - %(message)s')
__console_handler = StreamHandler(sys.stdout)
__console_handler.setFormatter(__formatter)
logger.addHandler(__console_handler)
enable_traceback = True


class ParseData:
    def __init__(self):
        self.mapping = {
            "date5": "Date",
            "Shift": "Shift",
            "fq_6102": "A1A023, A1A024",
            "fq_6100": "7303011675",
            "fq_6103": "E5E014,E5E003, E5E016",
            "fq_6104": "IV component",
            "fq_6143": "7302011030",
            "fq_6111": "Recovered 7302011030",
            "fq_6126": "Reaction Product",
            "fq_6099": "Package Scrubber Over Flow ",
            "fq_6127": "Package Scrubber Make Up ",
            "fq_318": "MEE To RPT",
            "fiq_1001": "Main 7302011030 Totaliser",
            "ut_fiq_102": "Flash Column Feed",
            "fiq_111": "Flash Column Bottom",
            "ft_801": "R#4  7302011030 Recovery Feed(FT-801)",
            "fiq_120": "Flash Column Ejector UIST01",
            "li_101": "T-101 level (%)",
            "fic_2453": "Doubt",
            "lic_2453": "Surge Tank Pyr",
            "pic_331": "A45",
            "li_363a": "B4",
            "li_363b": "C54",
            "li_363c": "D45",
            "ti_331r": "E4",
            "ti_331d": "F54",
            "ti_331c": "G54",
            "ti_331b": "H5",
            "ti_331e": "I454",
            "fi_331s": "J4",
            "tank_no": "K421",
            "leftover": "L2"
        }
        self.df = None
        self.shifts = ['a', 'b', 'c']
        self.date = None
        self.date_key = None
        self.final_dict = {}
        self.all_dict = {}

    def parse_the_data(self, input_list):
        final_list = []
        for input in range(0, len(input_list)):
            temp = {}
            for t, val in input_list[input][0].items():
                temp[
                    t.replace("12_00_am", "shift_a").replace("2_00_am", "shift_b").replace("4_00_am", "shift_c")] = val
            input_list[input][0] = temp
            self.all_dict = {**input_list[input][0], **input_list[input][1]}
            final_list.append(self.create_data(self.all_dict))
        self.create_df(final_list)

    def create_data(self, input):
        self.final_dict = input
        data_dict_A, data_dict_B, data_dict_C = {}, {}, {}
        for i, v in self.final_dict.items():
            my_list = i.split('_shift_')
            if len(my_list) == 1:
                self.date = str(v).split('T')[0]
                self.date_key = my_list[0]
                # print(self.date)
            else:
                # print(my_list)
                if my_list[1] == 'a':
                    data_dict_A[self.mapping[self.date_key]] = str(self.date)
                    data_dict_A[self.mapping[my_list[0]]] = v
                    data_dict_A['Shift'] = 'A'
                elif my_list[1] == 'b':
                    data_dict_B[self.mapping[self.date_key]] = str(self.date)
                    data_dict_B[self.mapping[my_list[0]]] = v
                    data_dict_B['Shift'] = 'B'
                elif my_list[1] == 'c':
                    data_dict_C[self.mapping[self.date_key]] = str(self.date)
                    data_dict_C[self.mapping[my_list[0]]] = v
                    data_dict_C['Shift'] = 'C'
        final_data = {}
        for k, v in data_dict_A.items():
            final_data[k] = [data_dict_A[k], data_dict_B[k], data_dict_C[k]]
        return final_data

    def create_df(self, x):
        final_data = {}
        for i in x:
            for k, v in self.mapping.items():
                if v not in final_data.keys():
                    final_data[v] = i[v]
                else:
                    final_data[v] = final_data[v] + i[v]
        df = pd.DataFrame(final_data)
        df.to_csv('parse.csv', index=False)


if __name__ == "__main__":
    dict_1 = {
        "date5": "2021-07-14T00:00:00+05:30",
        "fic_2453_12_00_am": "4",
        "lic_2453_12_00_am": "554",
        "pic_331_12_00_am": "45",
        "li_363a_12_00_am": "4",
        "li_363b_12_00_am": "54",
        "li_363c_12_00_am": "45",
        "ti_331r_12_00_am": "4",
        "ti_331d_12_00_am": "54",
        "ti_331c_12_00_am": "54",
        "ti_331b_12_00_am": "5",
        "ti_331e_12_00_am": "454",
        "fi_331s_12_00_am": "4",
        "tank_no_12_00_am": "421",
        "leftover_12_00_am": "2",
        "fic_2453_2_00_am": "1",
        "lic_2453_2_00_am": "21",
        "pic_331_2_00_am": "21",
        "li_363a_2_00_am": "21",
        "li_363b_2_00_am": "21",
        "li_363c_2_00_am": "2",
        "ti_331r_2_00_am": "1",
        "ti_331d_2_00_am": "21",
        "ti_331c_2_00_am": "2",
        "ti_331b_2_00_am": "1",
        "ti_331e_2_00_am": "15",
        "fi_331s_2_00_am": "4",
        "tank_no_2_00_am": "45",
        "leftover_2_00_am": "21",
        "fic_2453_4_00_am": "54",
        "lic_2453_4_00_am": "45",
        "pic_331_4_00_am": "51",
        "li_363a_4_00_am": "4",
        "li_363b_4_00_am": "5",
        "li_363c_4_00_am": "1",
        "ti_331r_4_00_am": "51",
        "ti_331d_4_00_am": "54",
        "ti_331c_4_00_am": "1",
        "ti_331b_4_00_am": "1",
        "ti_331e_4_00_am": "21",
        "fi_331s_4_00_am": "21",
        "tank_no_4_00_am": "87",
        "leftover_4_00_am": "51"
    }
    dict_2 = {
        "date5": "2021-07-14T00:00:00+05:30",
        "fq_6102_shift_a": "45",
        "fq_6100_shift_a": "12",
        "fq_6103_shift_a": "97",
        "fq_6104_shift_a": "45",
        "fq_6143_shift_a": "1",
        "fq_6111_shift_a": "21",
        "fq_6126_shift_a": "97",
        "fq_6099_shift_a": "4",
        "fq_6127_shift_a": "51",
        "fq_318_shift_a": "4",
        "fiq_1001_shift_a": "4",
        "ut_fiq_102_shift_a": "51",
        "fiq_111_shift_a": "1",
        "ft_801_shift_a": "654",
        "fiq_120_shift_a": "54",
        "li_101_shift_a": "51",
        "fq_6102_shift_b": "1",
        "fq_6100_shift_b": "5",
        "fq_6103_shift_b": "15",
        "fq_6104_shift_b": "4",
        "fq_6143_shift_b": "54",
        "fq_6111_shift_b": "54",
        "fq_6126_shift_b": "54",
        "fq_6099_shift_b": "54",
        "fq_6127_shift_b": "54",
        "fq_318_shift_b": "5",
        "fiq_1001_shift_b": "4",
        "ut_fiq_102_shift_b": "54",
        "fiq_111_shift_b": "415",
        "ft_801_shift_b": "6",
        "fiq_120_shift_b": "6",
        "li_101_shift_b": "6",
        "fq_6102_shift_c": "65",
        "fq_6100_shift_c": "749",
        "fq_6103_shift_c": "546",
        "fq_6104_shift_c": "66",
        "fq_6143_shift_c": "468",
        "fq_6111_shift_c": "74",
        "fq_6126_shift_c": "54",
        "fq_6099_shift_c": "64",
        "fq_6127_shift_c": "684",
        "fq_318_shift_c": "68",
        "fiq_1001_shift_c": "4",
        "ut_fiq_102_shift_c": "684",
        "fiq_111_shift_c": "64",
        "ft_801_shift_c": "684",
        "fiq_120_shift_c": "6",
        "li_101_shift_c": "864"
    }
    dict_3 = {
        "date5": "2021-07-15T00:00:00+05:30",
        "fic_2453_12_00_am": "4",
        "lic_2453_12_00_am": "554",
        "pic_331_12_00_am": "45",
        "li_363a_12_00_am": "4",
        "li_363b_12_00_am": "54",
        "li_363c_12_00_am": "45",
        "ti_331r_12_00_am": "4",
        "ti_331d_12_00_am": "54",
        "ti_331c_12_00_am": "54",
        "ti_331b_12_00_am": "5",
        "ti_331e_12_00_am": "454",
        "fi_331s_12_00_am": "4",
        "tank_no_12_00_am": "421",
        "leftover_12_00_am": "2",
        "fic_2453_2_00_am": "1",
        "lic_2453_2_00_am": "21",
        "pic_331_2_00_am": "21",
        "li_363a_2_00_am": "21",
        "li_363b_2_00_am": "21",
        "li_363c_2_00_am": "2",
        "ti_331r_2_00_am": "1",
        "ti_331d_2_00_am": "21",
        "ti_331c_2_00_am": "2",
        "ti_331b_2_00_am": "1",
        "ti_331e_2_00_am": "15",
        "fi_331s_2_00_am": "4",
        "tank_no_2_00_am": "45",
        "leftover_2_00_am": "21",
        "fic_2453_4_00_am": "54",
        "lic_2453_4_00_am": "45",
        "pic_331_4_00_am": "51",
        "li_363a_4_00_am": "4",
        "li_363b_4_00_am": "5",
        "li_363c_4_00_am": "1",
        "ti_331r_4_00_am": "51",
        "ti_331d_4_00_am": "54",
        "ti_331c_4_00_am": "1",
        "ti_331b_4_00_am": "1",
        "ti_331e_4_00_am": "21",
        "fi_331s_4_00_am": "21",
        "tank_no_4_00_am": "87",
        "leftover_4_00_am": "51"
    }
    dict_4 = {
        "date5": "2021-07-15T00:00:00+05:30",
        "fq_6102_shift_a": "45",
        "fq_6100_shift_a": "12",
        "fq_6103_shift_a": "97",
        "fq_6104_shift_a": "45",
        "fq_6143_shift_a": "1",
        "fq_6111_shift_a": "21",
        "fq_6126_shift_a": "97",
        "fq_6099_shift_a": "4",
        "fq_6127_shift_a": "51",
        "fq_318_shift_a": "4",
        "fiq_1001_shift_a": "4",
        "ut_fiq_102_shift_a": "51",
        "fiq_111_shift_a": "1",
        "ft_801_shift_a": "654",
        "fiq_120_shift_a": "54",
        "li_101_shift_a": "51",
        "fq_6102_shift_b": "1",
        "fq_6100_shift_b": "5",
        "fq_6103_shift_b": "15",
        "fq_6104_shift_b": "4",
        "fq_6143_shift_b": "54",
        "fq_6111_shift_b": "54",
        "fq_6126_shift_b": "54",
        "fq_6099_shift_b": "54",
        "fq_6127_shift_b": "54",
        "fq_318_shift_b": "5",
        "fiq_1001_shift_b": "4",
        "ut_fiq_102_shift_b": "54",
        "fiq_111_shift_b": "415",
        "ft_801_shift_b": "6",
        "fiq_120_shift_b": "6",
        "li_101_shift_b": "6",
        "fq_6102_shift_c": "65",
        "fq_6100_shift_c": "749",
        "fq_6103_shift_c": "546",
        "fq_6104_shift_c": "66",
        "fq_6143_shift_c": "468",
        "fq_6111_shift_c": "74",
        "fq_6126_shift_c": "54",
        "fq_6099_shift_c": "64",
        "fq_6127_shift_c": "684",
        "fq_318_shift_c": "68",
        "fiq_1001_shift_c": "4",
        "ut_fiq_102_shift_c": "684",
        "fiq_111_shift_c": "64",
        "ft_801_shift_c": "684",
        "fiq_120_shift_c": "6",
        "li_101_shift_c": "864"
    }
    dict_5 = {
        "date5": "2021-07-16T00:00:00+05:30",
        "fic_2453_12_00_am": "4",
        "lic_2453_12_00_am": "554",
        "pic_331_12_00_am": "45",
        "li_363a_12_00_am": "4",
        "li_363b_12_00_am": "54",
        "li_363c_12_00_am": "45",
        "ti_331r_12_00_am": "4",
        "ti_331d_12_00_am": "54",
        "ti_331c_12_00_am": "54",
        "ti_331b_12_00_am": "5",
        "ti_331e_12_00_am": "454",
        "fi_331s_12_00_am": "4",
        "tank_no_12_00_am": "421",
        "leftover_12_00_am": "2",
        "fic_2453_2_00_am": "1",
        "lic_2453_2_00_am": "21",
        "pic_331_2_00_am": "21",
        "li_363a_2_00_am": "21",
        "li_363b_2_00_am": "21",
        "li_363c_2_00_am": "2",
        "ti_331r_2_00_am": "1",
        "ti_331d_2_00_am": "21",
        "ti_331c_2_00_am": "2",
        "ti_331b_2_00_am": "1",
        "ti_331e_2_00_am": "15",
        "fi_331s_2_00_am": "4",
        "tank_no_2_00_am": "45",
        "leftover_2_00_am": "21",
        "fic_2453_4_00_am": "54",
        "lic_2453_4_00_am": "45",
        "pic_331_4_00_am": "51",
        "li_363a_4_00_am": "4",
        "li_363b_4_00_am": "5",
        "li_363c_4_00_am": "1",
        "ti_331r_4_00_am": "51",
        "ti_331d_4_00_am": "54",
        "ti_331c_4_00_am": "1",
        "ti_331b_4_00_am": "1",
        "ti_331e_4_00_am": "21",
        "fi_331s_4_00_am": "21",
        "tank_no_4_00_am": "87",
        "leftover_4_00_am": "51"
    }
    dict_6 = {
        "date5": "2021-07-16T00:00:00+05:30",
        "fq_6102_shift_a": "45",
        "fq_6100_shift_a": "12",
        "fq_6103_shift_a": "97",
        "fq_6104_shift_a": "45",
        "fq_6143_shift_a": "1",
        "fq_6111_shift_a": "21",
        "fq_6126_shift_a": "97",
        "fq_6099_shift_a": "4",
        "fq_6127_shift_a": "51",
        "fq_318_shift_a": "4",
        "fiq_1001_shift_a": "4",
        "ut_fiq_102_shift_a": "51",
        "fiq_111_shift_a": "1",
        "ft_801_shift_a": "654",
        "fiq_120_shift_a": "54",
        "li_101_shift_a": "51",
        "fq_6102_shift_b": "1",
        "fq_6100_shift_b": "5",
        "fq_6103_shift_b": "15",
        "fq_6104_shift_b": "4",
        "fq_6143_shift_b": "54",
        "fq_6111_shift_b": "54",
        "fq_6126_shift_b": "54",
        "fq_6099_shift_b": "54",
        "fq_6127_shift_b": "54",
        "fq_318_shift_b": "5",
        "fiq_1001_shift_b": "4",
        "ut_fiq_102_shift_b": "54",
        "fiq_111_shift_b": "415",
        "ft_801_shift_b": "6",
        "fiq_120_shift_b": "6",
        "li_101_shift_b": "6",
        "fq_6102_shift_c": "65",
        "fq_6100_shift_c": "749",
        "fq_6103_shift_c": "546",
        "fq_6104_shift_c": "66",
        "fq_6143_shift_c": "468",
        "fq_6111_shift_c": "74",
        "fq_6126_shift_c": "54",
        "fq_6099_shift_c": "64",
        "fq_6127_shift_c": "684",
        "fq_318_shift_c": "68",
        "fiq_1001_shift_c": "4",
        "ut_fiq_102_shift_c": "684",
        "fiq_111_shift_c": "64",
        "ft_801_shift_c": "684",
        "fiq_120_shift_c": "6",
        "li_101_shift_c": "864"
    }
    my_list = [[dict_1, dict_2], [dict_3, dict_4], [dict_5, dict_6]]
    my_obj = ParseData()
    my_obj.parse_the_data(my_list)
