import os
import dask
import dask.dataframe as dd
import os
import sys
import traceback
import pandas as pd
import logging
from logging import StreamHandler
from yield_calculated_columns import CalculatedColumns

logger = logging.getLogger("YieldReport")
logger.setLevel(os.environ.get("logger", "INFO"))
__formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(module)s - %(lineno)d - %(message)s')
__console_handler = StreamHandler(sys.stdout)
__console_handler.setFormatter(__formatter)
logger.addHandler(__console_handler)
enable_traceback = False


class yield_report:
    def __init__(self, path):
        self.df = self.read_csv(path)

    def read_csv(self, path):
        """
        This function is used to read dataframe using dask
        :param path: Path of CSV file
        :return: Data Frame
        """
        df = pd.read_csv(path)
        return df

    def add_calculate_columns(self):
        cal_obj = CalculatedColumns()
        try:
            self.df = cal_obj.fresh_7302011030(self.df)
            self.df = cal_obj.totaliser_7302011030(self.df)
            self.df = cal_obj.calculated_7303011675(self.df)
            self.df = cal_obj.calculated_IV_component(self.df)
            self.df = cal_obj.calculated_E5E014_E5E003_E5E016(self.df)
            self.df = cal_obj.total_7302011030(self.df)
            self.df = cal_obj.fresh_div_total_7302011030(self.df)
            self.df = cal_obj.A1A023_A1A024(self.df)
            self.df = cal_obj.A1A023_A1A024_plus_7303011675_plus_IV_component(self.df)
            self.df = cal_obj.PRODN_RXNPDT(self.df)
            self.df = cal_obj.Calculated_Scrubber(self.df)
            self.df = cal_obj.Calculated_MEE_to_RPT(self.df)
            self.df = cal_obj.surge_tank_total(self.df)
            self.df = cal_obj.make_up_to_mee_tank(self.df)
            self.df = cal_obj.norm_surge_tank_stage(self.df)
            self.df = cal_obj.norm_rpt_stage(self.df)
            self.df = cal_obj.calculate_yield(self.df)
            self.df = cal_obj.A1A023_A1A024_to_E5E014_E5E003_E5E016_Molar_ratio(self.df)
            self.df = cal_obj.A1A023_A1A024_to_Amm_Molar_ratio(self.df)
            self.df = cal_obj.E5E014_E5E003_E5E016_to_A1A023_A1A024_ratio_37(self.df)
            return self.df
        except Exception as e:
            logger.error(f"failed to calculate because of error {e}", exc_info=enable_traceback)


if __name__ == '__main__':
    my_obj = yield_report("test.csv")
    df = my_obj.add_calculate_columns()
    # df = df.compute()
    df.to_csv("output.csv")