from scripts.constants.app_configuration import METADATA
from scripts.core.utils.compliance_util import Compliance
from scripts.core.utils.timestamp_util import get_timestamps

if __name__ == '__main__':
    all_tags = METADATA['tags']
    tags_data = {}
    tags_type = ['upper', 'lower', 'live']
    for param, param_data in all_tags.items():
        for param_data_type in tags_type:
            tags_data[f'{param}_{param_data_type}'] = param_data[param_data_type]
    column_renamer = {v: k for k, v in tags_data.items()}
    payload = METADATA['query']
    start_date = METADATA['start_date']
    end_date = METADATA['end_date']
    all_timestamps = get_timestamps(start_date, end_date)
    payload['metrics'][0]['tags']['c3'] = list(column_renamer.keys())
    obj = Compliance(payload, column_renamer, all_tags)
    obj.start_calculation(all_timestamps)
