from datetime import datetime, timedelta

from loguru import logger

from scripts.errors import DateError


def get_timestamps(start_date, end_date):
    logger.info(f"Getting start and end time from {start_date} and {end_date}")
    s_date = datetime.strptime(start_date, "%Y-%m-%d")
    e_date = datetime.strptime(end_date, "%Y-%m-%d")
    e_date = e_date + timedelta(days=1)
    if s_date > e_date:
        raise DateError("Invalid Dates mentioned")
    my_dates = [s_date + timedelta(days=x) for x in range((e_date - s_date).days + 1)]
    start = 0
    end = len(my_dates)
    step = 30
    timestamps = []
    for i in range(start, end, step):
        x = i
        t_list = my_dates[x:x + step]
        start = t_list[0]
        end = t_list[-1] + timedelta(hours=24, minutes=0, seconds=0, milliseconds=0)
        end = min(end, e_date)
        timestamps.append({
            "start": int(start.timestamp()) * 1000,
            "end": int(end.timestamp()) * 1000
        })
    return timestamps
