from scripts.constants.app_configuration import METADATA, POSTGRES_URI
from scripts.core.utils.compliance_util import Compliance
from scripts.core.utils.timestamp_util import get_timestamps
from loguru import logger
import pandas as pd

if __name__ == '__main__':
    site_data = METADATA['site_data']
    df = pd.DataFrame()
    final_df_list = []
    tags_type = ['upper', 'lower', 'live']
    for site, site_metadata in site_data.items():
        logger.info(f"Generating for site {site}")
        all_tags = site_metadata['tags']
        tags_data = {}
        for param, param_data in all_tags.items():
            for param_data_type in tags_type:
                tags_data[f'{param}_{param_data_type}'] = param_data[param_data_type]
        column_renamer = {v: k for k, v in tags_data.items()}
        start_date = site_metadata['start_date']
        end_date = site_metadata['end_date']
        all_timestamps = get_timestamps(start_date, end_date)
        obj = Compliance(site, column_renamer, all_tags, list(tags_data.keys()))
        day_df = obj.start_calculation(all_timestamps)
        if len(day_df) > 0:
            day_df = day_df[day_df['event_date'] <= end_date]
            final_df_list.append(day_df)
        else:
            logger.info(f"For site {site} there is no data")
    if len(final_df_list) > 0:
        df = pd.concat(final_df_list)
        # df.set_index('client_name').to_sql("project_compliance", POSTGRES_URI, if_exists='replace')
        df.to_csv('delta-overall-compliance.csv', index=False)
