import os
import sys

import requests
import json
import pandas as pd
import time
import datetime

# from date and name are required

os.environ['config'] = '{"kairosdb_server": "http://192.168.0.207:8080","metric_name": "ilens.live_data.raw",' \
                       '"c3": "site_153$dept_1006$line_220$equipment_1258$tag_5790",   "start_absolute": "01/10/2020 ' \
                       '00:00:00","end_absolute": "30/11/2020 00:00:00","path": "/va"} '

query = {
    "metrics": [
        {
            "tags": {

            },
            "name": None,
            "aggregators": None,
            "group_by": None
        }

    ],
    "plugins": [],
    "cache_time": 0,
    "start_absolute": None,
    "end_absolute": None,
    "start_relative": {
        "value": None,
        "unit": None
    },
    "end_relative": {
        "value": None,
        "unit": None
    }
}



def read_kairos(config):
    # post method
    start_abs_flag = False
    start_rel_flag = False
    end_abs_flag = False
    end_rel_flag = False
    if "kairosdb_server" in config.keys():
        kairosdb_server = config['kairosdb_server']
    else:
        raise Exception("Kairos url should be required")
    if config["c3"] is not None and len(config["c3"]) > 0:
        pass
    else:
        raise Exception("c3 values should not be null")
    if "metric_name" in config.keys():
        query["metrics"][0]["name"] = config["metric_name"]
    else:
        print("metric_name key is not there")
        raise Exception("metric_name key is not there")
    if "start_absolute" in config.keys():
        start_time = config['start_absolute']
        try:
            start_timestamp = datetime.datetime.strptime(start_time, "%d/%m/%Y %H:%M:%S")
            start_abs_flag = True
            timestamp_start = datetime.datetime.timestamp(start_timestamp)
            query["start_absolute"] = int(timestamp_start) * 1000
            query.pop("start_relative")
        except:
            raise Exception("start time should be dd/mm/yyyy hh/MM/SS")
    elif "start_relative" in config.keys():
        if config['start_relative']['value'] > 0:
            start_rel_flag = True
            query['start_relative']['value'] = config['start_relative']['value']
            query['start_relative']['unit'] = config['start_relative']['unit']
            query.pop("start_absolute")
        else:
            raise Exception("start time should be greater than zero")
    else:
        print("need start date key")
        raise Exception("need start date key")
    if "end_absolute" in config.keys():
        end_time = config['end_absolute']
        try:
            end_timestamp = datetime.datetime.strptime(end_time, "%d/%m/%Y %H:%M:%S")
            end_abs_flag = True
            timestamp_end = datetime.datetime.timestamp(end_timestamp)
            query["end_absolute"] = int(timestamp_end) * 1000
            query.pop("end_relative")
        except:
            raise Exception("start time should be dd/mm/yyyy hh/MM/SS")

    elif "end_relative" in config.keys():

        if config['end_relative']['value'] > 0:
            end_rel_flag = True
            query['end_relative']['value'] = config['end_relative']['value']
            query['end_relative']['unit'] = config['end_relative']['unit']
            query.pop("end_absolute")
        else:
            raise Exception("end time should be greater than zero and less than start time")
    else:
        # pop both keys
        query.pop("end_absolute")
        query.pop("end_relative")

    if 'aggregators' not in config.keys():
        query['metrics'][0].pop('aggregators')
    if 'group_by' not in config.keys():
        query['metrics'][0].pop('group_by')
    if "c3" in config.keys():
        query["metrics"][0]["tags"]["c3"] = [config["c3"]]
    else:
        raise Exception("required tag name c3")
    print(type(query))
    print(query)
    response = requests.post(kairosdb_server + "/api/v1/datapoints/query", data=json.dumps(query))
    # print("Status code: %d" % response.status_code)
    # print(type(response.status_code))
    if response.status_code == 200:
        # print(response.text)
        data = response.json()["queries"][0]["results"][0]["values"]

        # create df
        df = pd.DataFrame.from_dict(data)
        return df
    else:
        raise Exception(response.json()['errors'])


if __name__ == "__main__":
    config = json.loads(os.environ.get('config'))
    if config is None:
        sys.stderr.write("Configuration not found...")
        sys.stderr.write("Exiting....")
        sys.exit(1)
    main_path = "/opt"
    if not os.path.exists(main_path + config['path']):
        os.makedirs(main_path + config['path'])
    df = read_kairos(config)
    try:
        path = os.path.join(main_path + config['path'], "out.csv")
        # print(path)
        df.to_csv(path)
    except:
        raise Exception("Failed to create csv file")
