from scripts.common.constants import KariosConstants


def str2bool(txt):
    if str(txt).lower() in ['True', 'true', 1, '1', True, 'yes']:
        return True
    return False


def get_value_or_raise_exception(dictionary, key):
    value = dictionary.get(key)
    if value is None:
        raise Exception("Invalid/Missing value for the key {} in {}".format(key, dictionary))
    return value


def get_aggregation_query(config):
    agg_dict = {
        KariosConstants.NAME_KEY: get_value_or_raise_exception(config, KariosConstants.AGGREGATION_OPS).lower(),
        KariosConstants.SAMPLING_KEY: {
            KariosConstants.VALUE_KEY: get_value_or_raise_exception(config, KariosConstants.AGGREGATION_SAMPLING_VALUE),
            KariosConstants.UNIT_KEY: get_value_or_raise_exception(config, KariosConstants.AGGREGATION_SAMPLING_UNIT).lower()
        }
    }
    if KariosConstants.ALIGNMENT_MAPPING.get(KariosConstants.AGGREGATION_ALIGNMENT) is not None:
        agg_dict[KariosConstants.ALIGNMENT_MAPPING.get(KariosConstants.AGGREGATION_ALIGNMENT)] = True
    return agg_dict
