# Multipipeline Kairos Read Component for Batch Pipelines

### Pass in the configurations:
```python
{
    "shared_volume":"/mnt",
    "end_absolute":"",
    "start_absolute":"",
    "start_relative": "3",
    "end_relative": "",
    "start_relative_unit": "Years",
    "end_relative_unit": "",
    "tag_hierarchy":{
        "pressure_values":"site_194$dept_1022$line_287$equipment_3824$tag_6663"
        },
    "metric_name":"ilens.live_data.raw",
    "kairosdb_url":"http://192.168.0.207:8080 ",
    "aggregation_ops":"MAX",
    "aggregation_sampling_value":"1",
    "aggregation_sampling_unit":"Days",
    "aggregation_alignment":"None"
}
```

### Run Docker Container mounting the same directory to which the csv file is to be written
```
docker run 
    -v /mnt:/mnt
    -e shared_volume="/mnt"
    -e end_absolute=""
    -e start_absolute=""
    -e start_relative="3"
    -e end_relative=""
    -e start_relative_unit="Years"
    -e end_relative_unit=""
    -e tag_hierarchy='{"pressure_values":"site_194$dept_1022$line_287$equipment_3824$tag_6663"}'
    -e metric_name=ilens.live_data.raw
    -e kairosdb_url=http://192.168.0.207:8080
    -e aggregation_ops=MAX
    -e aggregation_sampling_value=1
    -e aggregation_sampling_unit=Days
    -e aggregation_alignment=None
    -e LOG_LEVEL=info
    azacrknowledgelens.azurecr.io/ai-forecasting/batch-multi-karios-read-component:v0.7
```