#!/usr/bin/env python
import os
import sys
import yaml
import json

# os.environ['config'] = '{"kairosdb_url": "http://192.168.0.207:8080",' \
#                        '"metric_name": "ilens.live_data.raw",' \
#                        '"tag_hierarchy": "site_153$dept_1006$line_220$equipment_1258$tag_5790",' \
#                        '"start_absolute": "01/10/2020 00:00:00",' \
#                        '"end_absolute": "30/11/2020 00:00:00",' \
#                        '"shared_volume": "/mnt"}'

config_path = os.path.join(os.getcwd(), "conf", "configuration.yml")
if os.path.exists(config_path):
    sys.stderr.write("Reading config from --> {}".format(config_path))
    sys.stderr.write("\n")

    with open(config_path, 'r') as stream:
        _config = yaml.safe_load(stream)
else:
    sys.stderr.write("Configuration not found...")
    sys.stderr.write("Exiting....")
    sys.exit(1)

BASE_LOG_PATH = os.path.join(os.getcwd(), "logs")
if not os.path.exists(os.path.join(os.getcwd(), 'logs')):
    os.mkdir(os.path.join(os.getcwd(), 'logs'))

LOG_LEVEL = os.environ.get("LOG_LEVEL" ,_config.get('SERVICE_CONFIG', {}).get("LOG_LEVEL", "INFO")).upper()
LOG_HANDLER_NAME = _config.get('SERVICE_CONFIG', {}).get("LOG_HANDLER_NAME", "ReadFromKairos")

# config = json.loads(os.environ.get('config'))
config = {
    "shared_volume": os.environ.get("shared_volume"),
    "end_absolute": os.environ.get("end_absolute"),
    "start_absolute": os.environ.get("start_absolute"),
    "tag_hierarchy": json.loads(os.environ.get("tag_hierarchy")),
    "metric_name": os.environ.get("metric_name"),
    "kairosdb_url": os.environ.get("kairosdb_url")
}
if not os.path.exists(config['shared_volume']):
    sys.stderr.write("Shared path does not exist!")
    sys.stderr.write("Creating path --> {}".format(config['shared_volume']))
    os.makedirs(config['shared_volume'])
