# Read_from_Kairos_Component


#Use the below script to convert .pt to onnx.

```python
# Import required libraries
import torch
import torchvision.models as models

# Use an existing model from Torchvision, note it
# will download this if not already on your computer (might take time)
model = create_cnn_model(models.resnet34, nc=5)
model.load_state_dict(torch.load("/content/best_resnet34.pth")["model"])

# Create some sample input in the shape this model expects
dummy_input = torch.randn(10, 3, 224, 224)

# # It's optional to label the input and output layers
# input_names = [ "actual_input_1" ] + [ "learned_%d" % i for i in range(16) ]
# output_names = [ "output1" ]

# Use the exporter from torch to convert to onnx
# model (that has the weights and net arch)
torch.onnx.export(model, dummy_input, "resnet34.onnx", verbose=True)
