#!/usr/bin/env python

class KariosConstants:
    KAIROS_URL_KEY = "kairosdb_url"
    METRIC_NAME_KEY = "metric_name"
    TAG_HIERARCHY_KEY = "tag_hierarchy"
    SHARED_VOLUME_KEY = "shared_volume"
    START_ABSOLUTE_KEY = "start_absolute"
    START_RELATIVE_KEY = "start_relative"
    END_ABSOLUTE_KEY = "end_absolute"
    END_RELATIVE_KEY = "end_relative"
    VALUE_KEY = "value"
    VALUES_KEY = "values"
    METRICS_KEY = "metrics"
    NAME_KEY = "name"
    UNIT_KEY = "unit"
    AGGREGATORS_KEY = "aggregators"
    GROUPBY_KEY = "group_by"
    TAGS_KEY = "tags"
    C3_KEY = "c3"
    QUERIES_KEY = "queries"
    RESULTS_KEY = "results"
    ERRORS_KEY = "errors"
    DATETIME_FORMAT = "%d/%m/%Y %H:%M:%S"
    KARIOS_API = "/api/v1/datapoints/query"
    REQUEST_SUCCESS_CODE = 200
    PLUGINS_KEY = "plugins"
    CACHE_TIME_KEY = "cache_time"
    QUERY = {
        METRICS_KEY: [
            {
                TAGS_KEY: {

                },
                NAME_KEY: None,
                AGGREGATORS_KEY: None,
                GROUPBY_KEY: None
            }

        ],
        PLUGINS_KEY: [],
        CACHE_TIME_KEY: 0,
        START_ABSOLUTE_KEY: None,
        END_ABSOLUTE_KEY: None,
        START_RELATIVE_KEY: {
            VALUE_KEY: None,
            UNIT_KEY: None
        },
        END_RELATIVE_KEY: {
            VALUE_KEY: None,
            UNIT_KEY: None
        }
    }


class ComponentExceptions:
    INVALID_KAIROS_URL_EXCEPTION = "Kairos url should be required"
    INVALID_TAG_HIERARCHY_EXCEPTION = "Tag Hierarchy values should not be null"
    INVALID_METRIC_NAME_EXCEPTION = "metric_name key is not there"
    INVALID_START_TIME_FORMAT_EXCEPTION = "start time should be dd/mm/yyyy hh/MM/SS"
    INVALID_END_TIME_FORMAT_EXCEPTION = "end time should be dd/mm/yyyy hh/MM/SS"
    INVALID_START_TIME_VALUE_EXCEPTION = "start time should be greater than zero"
    MISSING_START_TIME_VALUE_EXCEPTION = "need start date key"
    MISSING_TAG_HIERARCHY_EXCEPTION = "required tag hierarchy"
    INVALID_START_END_VALUE_EXCEPTION = "end time should be greater than zero and less than start time"
