from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

import os
import logging
from logging.handlers import RotatingFileHandler

from scripts.common.config_parser import LOG_LEVEL, LOG_HANDLER_NAME, BASE_LOG_PATH

DEFAULT_FORMAT = '%(asctime)s %(levelname)5s %(name)s %(message)s'
DEBUG_FORMAT = '%(asctime)s %(levelname)5s %(name)s [%(threadName)5s:%(filename)5s:%(funcName)5s():%(lineno)s] %(' \
               'message)s '
EXTRA = {}
FORMATTER = DEFAULT_FORMAT
if LOG_LEVEL.strip() == "DEBUG":
    FORMATTER = DEBUG_FORMAT
logging.trace = logging.DEBUG - 5
logging.addLevelName(logging.DEBUG - 5, 'TRACE')


class ILensLogger(logging.getLoggerClass()):
    def __init__(self, name):
        super().__init__(name)

    def trace(self, msg, *args, **kwargs):
        if self.isEnabledFor(logging.trace):
            self._log(logging.trace, msg, args, **kwargs)


def get_logger(log_handler_name):
    """
    Purpose : To create logger .
    :param log_handler_name: Name of the log handler.
    :return: logger object.
    """
    log_path = os.path.join(BASE_LOG_PATH, log_handler_name + ".log")
    logging.setLoggerClass(ILensLogger)
    _logger = logging.getLogger(log_handler_name)
    _logger.setLevel(LOG_LEVEL.strip().upper())
    log_handler = logging.StreamHandler()
    log_handler.setLevel(LOG_LEVEL)
    formatter = logging.Formatter(FORMATTER)
    log_handler.setFormatter(formatter)
    handler = RotatingFileHandler(log_path, maxBytes=10485760,
                                  backupCount=5)
    handler.setFormatter(formatter)
    _logger.addHandler(log_handler)
    _logger.addHandler(handler)
    return _logger


logger = get_logger(LOG_HANDLER_NAME)
