#!/usr/bin/env python
import os
import sys
import yaml
import json
from scripts.common.constants import PushDatatoPostgreSqlConstants

config_path = os.path.join(os.getcwd(), "conf", "dev-configuration.yml")
if os.path.exists(config_path):
    sys.stderr.write("Reading config from --> {}".format(config_path))
    sys.stderr.write("\n")

    with open(config_path, 'r') as stream:
        _config = yaml.safe_load(stream)
else:
    sys.stderr.write("Configuration not found...")
    sys.stderr.write("Exiting....")
    sys.exit(1)
# uncomment for Testing
# os.environ['pipeline_id'] = "pipe1"
# os.environ['artifact_base_path'] = "/data/model/tested/"
# os.environ['artifact_name'] = 'response.json'
# ------------------------ Configurations -----------------------------------------------------------------------------
pipeline_id = os.environ.get('PIPELINE_ID', default="pipeline_313")
shared_mount_base_ai_job = os.environ.get("shared_mount_base_ai_job",
                                          _config.get("SYSTEM_CONFIG", {}).get('shared_mount_base_ai_job'))

# read from $shared_mount_base_ai_job/$pipeline_id/run.config
run_id_path = os.path.join(shared_mount_base_ai_job, pipeline_id, "run_config.json")
try:
    sys.stderr.write("Checking for run id parameters at path " + run_id_path + "\n")
    with open(run_id_path) as f:
        run_id_param = json.load(f)
    run_id = run_id_param['run_id']
except Exception as e:
    sys.stderr.write("No run_config.json file is there so keeping run id as default_run_id  " + "\n")
    run_id = _config.get("SYSTEM_CONFIG", {}).get('default_run_id')

historic_data_path = os.path.join(shared_mount_base_ai_job, 'historical_weather_data')

# ----------------------Postgres----------------------------------------------------------------------------------------

postgres_host = _config.get("POSTGRES_CONFIG", {}).get('host')
postgres_port = int(_config.get("POSTGRES_CONFIG", {}).get('port'))
postgres_database = _config.get("POSTGRES_CONFIG", {}).get('database')

# ----------------------------------------------------------------------------------------------------------------------

BASE_LOG_PATH = os.path.join(os.getcwd(), "logs")
if not os.path.exists(os.path.join(os.getcwd(), 'logs')):
    os.mkdir(os.path.join(os.getcwd(), 'logs'))

LOG_LEVEL = os.environ.get("LOG_LEVEL", _config.get('SERVICE_CONFIG', {}).get("LOG_LEVEL", "INFO")).upper()
LOG_HANDLER_NAME = _config.get('SERVICE_CONFIG', {}).get("LOG_HANDLER_NAME", "PushDatatoPostgreSql")
ENABLE_LOGSTASH_LOG = os.environ.get("ENABLE_LOGSTASH_LOG", 'False').lower()
LOGSTASH_HOST = _config.get('SERVICE_CONFIG', {}).get('LOGSTASH_HOST')
LOGSTASH_PORT = str(_config.get('SERVICE_CONFIG', {}).get('LOGSTASH_PORT'))

config = {
    'pipeline_id': pipeline_id,
    'run_id': run_id,
    'shared_mount_base_ai_job': shared_mount_base_ai_job,
    'component_output_dir': historic_data_path,
}

if not os.path.exists(config['shared_mount_base_ai_job']):
    sys.stderr.write("Shared path does not exist!" + "\n")
    sys.stderr.write("Creating path --> {}".format(config['shared_mount_base_ai_job'] + "\n"))
    os.makedirs(config['shared_mount_base_ai_job'])

if not os.path.exists(config['component_output_dir']):
    sys.stderr.write("component_output_dir does not exist!" + "\n")
    sys.stderr.write("Creating path --> {}".format(config['component_output_dir'] + "\n"))
    os.makedirs(config['component_output_dir'])
