#!/usr/bin/env python
import os
import sys
import yaml
import json
from pymongo import MongoClient, DESCENDING
from scripts.common.constants import PreprocessWeatherDataConstants

config_path = os.path.join(os.getcwd(), "conf", "configuration.yml")
if os.path.exists(config_path):
    sys.stderr.write("Reading config from --> {}".format(config_path))
    sys.stderr.write("\n")

    with open(config_path, 'r') as stream:
        _config = yaml.safe_load(stream)
else:
    sys.stderr.write("Configuration not found...")
    sys.stderr.write("Exiting....")
    sys.exit(1)
# For testing uncomment this
# os.environ['pipeline_id'] = "pipe1"
# ------------------------ Configurations -----------------------------------------------------------------------------
pipeline_id = os.environ.get('PIPELINE_ID', default="pipeline_313")
shared_mount_base_ai_job = os.environ.get("shared_mount_base_ai_job",
                                          _config.get("SYSTEM_CONFIG", {}).get('shared_mount_base_ai_job'))
# read from $shared_mount_base_ai_job/$pipeline_id/run.config
run_id_path = shared_mount_base_ai_job + "/" + pipeline_id + "/run_config.json"
try:
    sys.stderr.write("Checking for run id parameters at path " + run_id_path + "\n")
    with open(run_id_path) as f:
        run_id_param = json.load(f)
except Exception as e:
    raise Exception(e)
run_id = run_id_param['run_id']
fillna_method = os.environ.get("fillna_method", default="ffill")

# shared_mount_base_ai_job/$pipeline_id/$run_id/PreprocessWeatherData/input/$.json
component_input = shared_mount_base_ai_job + "/" + pipeline_id + "/" + run_id + "/" + PreprocessWeatherDataConstants.COMPONENT_NAME + "/input"
# shared_mount_base_ai_job/$pipeline_id/$run_id/RunModel/input/data.csv
component_output_dir = shared_mount_base_ai_job + "/" + pipeline_id + "/" + run_id + "/" + PreprocessWeatherDataConstants.NEXT_COMPONENT + "/input"


BASE_LOG_PATH = os.path.join(os.getcwd(), "logs")
if not os.path.exists(os.path.join(os.getcwd(), 'logs')):
    os.mkdir(os.path.join(os.getcwd(), 'logs'))

LOG_LEVEL = os.environ.get("LOG_LEVEL", _config.get('SERVICE_CONFIG', {}).get("LOG_LEVEL", "INFO")).upper()
LOG_HANDLER_NAME = _config.get('SERVICE_CONFIG', {}).get("LOG_HANDLER_NAME", "PreprocessWeatherData")
ENABLE_LOGSTASH_LOG = os.environ.get("ENABLE_LOGSTASH_LOG", 'False').lower()
LOGSTASH_HOST = _config.get('SERVICE_CONFIG', {}).get('LOGSTASH_HOST')
LOGSTASH_PORT = str(_config.get('SERVICE_CONFIG', {}).get('LOGSTASH_PORT'))

# os.environ["shared_volume"] = "test"
# os.environ["json_path"] = r"E:\welspun-defects\preprocess_data-ilendev\response.json"
# os.environ["fillna_method"] = "ffill"
# os.environ["standard_scalar_path"] = r"E:\welspun-defects\preprocess_data-ilendev\StandardScaler.pkl"
# print(os.getcwd())
config = {
    'pipeline_id': pipeline_id,
    'run_id': run_id,
    'shared_mount_base_ai_job': shared_mount_base_ai_job,
    'fillna_method': fillna_method,
    'component_input': component_input,
    'component_output_dir': component_output_dir
}
if not os.path.exists(config['shared_mount_base_ai_job']):
    sys.stderr.write("Shared path does not exist!" + "\n")
    sys.stderr.write("Creating path --> {}".format(config['shared_mount_base_ai_job'] + "\n"))
    os.makedirs(config['shared_mount_base_ai_job'])

if not os.path.exists(config['component_output_dir']):
    sys.stderr.write("component_output_dir does not exist!" + "\n")
    sys.stderr.write("Creating path --> {}".format(config['component_output_dir'] + "\n"))
    os.makedirs(config['component_output_dir'])
