import json
import pickle
import traceback
import os
import pandas as pd
from sklearn.preprocessing import StandardScaler
from scripts.common.config_parser import *
from scripts.common.constants import PreprocessWeatherDataConstants, ComponentExceptions
from scripts.common.logsetup import logger


class PreProcessComponent:
    def __init__(self):
        self.ds, self.tempmax, self.tempmin, self.temp, self.humidity, self.precip, self.winddir, self.cloudcover, self.visibility, self.date, self.windspeed = (
            [] for i in range(11))

    def read_pickle_file(self, file):
        try:
            logger.info("Parsing the pickle file at location " + file + " ......")
            return pickle.load(open(file, "rb"))
        except:
            logger.info("Failed to read pickle file")
            logger.info("----Traceback----")
            logger.info(traceback.format_exc())

    def preprocess(self, forcast_json, null_value_method):

        try:
            logger.info("Reading Json file")
            with open(forcast_json) as f:
                data = json.load(f)
        except:
            logger.info("Failed reading Json File")
            logger.info(traceback.format_exc())
        try:
            for i in data[PreprocessWeatherDataConstants.DAYS_KEY]:
                self.date.append(i[PreprocessWeatherDataConstants.DATETIME_KEY])
                self.ds.append(int(i[PreprocessWeatherDataConstants.DATETIME_KEY].split("-")[1]))
                self.tempmax.append(i[PreprocessWeatherDataConstants.TEMPMAX_KEY])
                self.tempmin.append(i[PreprocessWeatherDataConstants.TEMPMIN_KEY])
                self.temp.append(i[PreprocessWeatherDataConstants.TEMP_KEY])
                self.humidity.append(i[PreprocessWeatherDataConstants.HUMIDITY_KEY])
                self.precip.append(i[PreprocessWeatherDataConstants.PRECIP_KEY])
                self.windspeed.append(i[PreprocessWeatherDataConstants.WINDSPEED_KEY])
                self.winddir.append(i[PreprocessWeatherDataConstants.WINDDIR_KEY])
                self.cloudcover.append(i[PreprocessWeatherDataConstants.CLOUDCOVER_KEY])
                self.visibility.append(i[PreprocessWeatherDataConstants.VISIBILITY_KEY])
            forcast_data = pd.DataFrame(
                {"Maximum Temperature": self.tempmax, "Minimum Temperature": self.tempmin, "Temperature": self.temp,
                 "Precipitation": self.precip, "Wind Speed": self.windspeed, "Wind Direction": self.winddir,
                 "Visibility": self.visibility, "Cloud Cover": self.cloudcover,
                 "Relative Humidity": self.humidity, "month": self.ds})
            forcast_data.fillna(method=null_value_method, inplace=True)
            forcast_data.index = self.date
            return forcast_data
        except:
            logger.info(traceback.format_exc())

if __name__ == '__main__':
    try:
        # Checking json path
        json_path_dir = config[PreprocessWeatherDataConstants.COMPONENT_INPUT_DIR]
        json_path = os.path.join(json_path_dir, os.listdir(json_path_dir)[0])
    except Exception as e:
        logger.info(traceback.format_exc())
        raise Exception(e)

    # Checking Fill NA method
    if PreprocessWeatherDataConstants.FILLNA_METHOD in config.keys():
        fillna_method = config[PreprocessWeatherDataConstants.FILLNA_METHOD]
    else:
        raise Exception(ComponentExceptions.INVALID_Fillna_Method)
    obj = PreProcessComponent()
    forcast_df = obj.preprocess(json_path, fillna_method)
    try:
        logger.info("Writing forcast data to csv file at " + os.path.join(config['component_output_dir'], 'data.csv'))
        output2 = os.path.join(config['component_output_dir'], 'data.csv')
        forcast_df.to_csv(output2, index=True)
        logger.info("Component executed Successfully")
    except Exception as e:
        raise Exception(e)
