import json
import pickle

import pandas as pd

from scripts.common.config_parser import *
from scripts.common.constants import PreProcessConstants, ComponentExceptions
from scripts.common.logsetup import logger


class PreProcessComponent:
    def __init__(self):
        self.ds, self.tempmax, self.tempmin, self.temp, self.humidity, self.precip, self.winddir, self.cloudcover, self.visibility, self.date, self.windspeed = ([] for i in range(11))

    def read_pickle_file(self, file):
        logger.info("Parsing the pickle file at location "+file)
        return pickle.load(open(file, "rb"))

    def preprocess(self, forcast_json, standard_scalar_pkl_path, null_value_method):
        logger.info("Reading Json file")
        with open(forcast_json) as f:
            data = json.load(f)
        for i in data[PreProcessConstants.DAYS_KEY]:
            self.date.append(i[PreProcessConstants.DATETIME_KEY])
            self.ds.append(int(i[PreProcessConstants.DATETIME_KEY].split("-")[1]))
            self.tempmax.append(i[PreProcessConstants.TEMPMAX_KEY])
            self.tempmin.append(i[PreProcessConstants.TEMPMIN_KEY])
            self.temp.append(i[PreProcessConstants.TEMP_KEY])
            self.humidity.append(i[PreProcessConstants.HUMIDITY_KEY])
            self.precip.append(i[PreProcessConstants.PRECIP_KEY])
            self.windspeed.append(i[PreProcessConstants.WINDSPEED_KEY])
            self.winddir.append(i[PreProcessConstants.WINDDIR_KEY])
            self.cloudcover.append(i[PreProcessConstants.CLOUDCOVER_KEY])
            self.visibility.append(i[PreProcessConstants.VISIBILITY_KEY])
        forcast_data = pd.DataFrame(
            {"Maximum Temperature": self.tempmax, "Minimum Temperature": self.tempmin, "Temperature": self.temp,
             "Precipitation": self.precip, "Wind Speed": self.windspeed, "Wind Direction": self.winddir,
             "Visibility": self.visibility, "Cloud Cover": self.cloudcover,
             "Relative Humidity": self.humidity, "month": self.ds})
        forcast_data.fillna(method=null_value_method, inplace=True)

        sc_X = self.read_pickle_file(standard_scalar_pkl_path)
        X = sc_X.transform(forcast_data)
        return X


if __name__ == '__main__':
    # Checking shared Volume
    if PreProcessConstants.SHARED_VOLUME in config.keys():
        shared_volume = config[PreProcessConstants.SHARED_VOLUME]
    else:
        raise Exception(ComponentExceptions.INVALID_SHARED_VOLUME)

    # Checking json path
    if PreProcessConstants.JSON_PATH in config.keys():
        json_path = config[PreProcessConstants.JSON_PATH]
    else:
        raise Exception(ComponentExceptions.INVALID_JSON_PATH)

    # Checking pickle path for standard scalar
    if PreProcessConstants.STANDARD_SCALAR_PATH in config.keys():
        standard_scalar_path = config[PreProcessConstants.STANDARD_SCALAR_PATH]
    else:
        raise Exception(ComponentExceptions.INVALID_JSON_PATH)

    # Checking Fill NA method
    if PreProcessConstants.FILLNA_METHOD in config.keys():
        fillna_method = config[PreProcessConstants.FILLNA_METHOD]
    else:
        raise Exception(ComponentExceptions.INVALID_Fillna_Method)

    obj = PreProcessComponent()
    data = obj.preprocess(json_path, standard_scalar_path, fillna_method)
    logger.info("Got the data writing it to pickle file (preprocessed_X.pkl)")
    try:
        output = open(os.path.join(shared_volume, 'preprocessed_X.pkl'), 'wb')
        pickle.dump(data, output)
        output.close()
        logger.info("Component executed Successfully")
    except Exception as e:
        raise Exception(e)
