import datetime
from postgre import Postgres
import logging
import os
import sys
from functools import partial
from ftplib import FTP
from logging import StreamHandler
import socket
from multiprocessing.pool import ThreadPool

logger = logging.getLogger("postgre_ftp_clean_up")
logger.setLevel(os.environ.get("logger", "DEBUG"))
__formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(module)s - %(lineno)d - %(message)s')
__console_handler = StreamHandler(sys.stdout)
__console_handler.setFormatter(__formatter)
logger.addHandler(__console_handler)

check_for_n_hours = int(os.environ.get('check_for_n_hours', default='3'))
THREAD_POOL_LIMIT = os.environ.get("THREAD_POOL_LIMIT", default=10)
FTP_HOST = os.environ.get("FTP_HOST", default="hfe-ftp.ilens.io")
FTP_USER = os.environ.get("FTP_USER", default="ilenshero1")
FTP_PASS = os.environ.get("FTP_PASS", default="ilenshfe123")
FTP_MODBUS_DIRECTORY = os.environ.get("FTP_MODBUS_DIRECTORY", default="/upload/DATA/MODBUS/")
FTP_IO_DIRECTORY = os.environ.get("FTP_IO_DIRECTORY", default="/upload/DATA/IO/")
FTP_WPM_DIRECTORY = os.environ.get("FTP_WPM_DIRECTORY", default="/upload/DATA/")
FTP_TARGET_DIRECTORY = os.environ.get("FTP_DIRECTORY")
NUMBER_OF_SPLITS = int(os.environ.get("NUMBER_OF_SPLITS", 20))


class SmartFTP(FTP):
    def makepasv(self):
        self.af = socket.AF_INET6
        invalidhost, port = super(SmartFTP, self).makepasv()
        return self.host, port


def remove(path, source_directory, ftp_host=FTP_HOST, ftp_user=FTP_USER, ftp_pass=FTP_PASS):
    try:
        ftp = SmartFTP(ftp_host, ftp_user, ftp_pass)
        ftp.login(ftp_user, ftp_pass)
        ftp.cwd(source_directory)
        ftp.delete(os.path.basename(path))
        logger.info("changing directory to {}".format(source_directory))
        logger.info("getting file list")
        logger.info("removing ftp file {}".format(path))
        ftp.close()
        return path
    except:
        logger.info(f"Skipping {path}")


if __name__ == "__main__":
    logger.info("making postgre conection")
    pg = Postgres()
    time_stamp = datetime.datetime.utcnow() - datetime.timedelta(hours=check_for_n_hours)
    file_list = pg.get_file_names('hfe_master_file_status', time_stamp)
    final_file_list = []
    WPM_list = []
    for i in range(0, len(file_list)):
        if "WPM" in file_list[i]:
            WPM_list.append(file_list[i])
        else:
            final_file_list.append(file_list[i])
    print(len(file_list), file_list)
    IO_list = [i for i in final_file_list if 'IO' in i]
    MODBUS_list = [i for i in final_file_list if 'MODBUS' in i]
    print(len(final_file_list), final_file_list)
    print(len(WPM_list), WPM_list)
    print(len(IO_list), IO_list)
    print(len(MODBUS_list), MODBUS_list)
    logger.info("Closing Postgre Connection")
    pg.close_connection()
    THREAD_POOL_LIMIT = 20
    pool = ThreadPool(int(THREAD_POOL_LIMIT))
    if len(WPM_list) > 0:
        try:
            logger.info(f"Removing WPM files....")
            prod_x = partial(remove, source_directory=FTP_WPM_DIRECTORY)
            map_output = pool.map(prod_x, WPM_list)
        except Exception as e:
            logger.info(e)
    else:
        logger.info(f"No WPM files after {time_stamp}")
    if len(IO_list) > 0:
        try:
            logger.info(f"Removing IO files....")
            prod_x = partial(remove, source_directory=FTP_IO_DIRECTORY)
            map_output = pool.map(prod_x, IO_list)
        except Exception as e:
            logger.info(e)
    else:
        logger.info(f"No IO files after {time_stamp}")
    if len(MODBUS_list) > 0:
        try:
            logger.info(f"Removing MODBUS files....")
            prod_x = partial(remove, source_directory=FTP_MODBUS_DIRECTORY)
            map_output = pool.map(prod_x, MODBUS_list)
        except Exception as e:
            logger.info(e)
    else:
        logger.info(f"No MODBUS files after {time_stamp}")