import logging
# from PostgreSQLV1_Constants import password
import os
import sys
from logging import StreamHandler

import psycopg2

logger = logging.getLogger("POSTGRE")
logger.setLevel('INFO')
__formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(module)s - %(lineno)d - %(message)s')
__console_handler = StreamHandler(sys.stdout)
__console_handler.setFormatter(__formatter)
logger.addHandler(__console_handler)

password = ""

# Host: postgres-db-service.ilens-infra
# Port: 5432
# DB Name: ilens-hfae
# Username: hfae
# Passwd: iLens#4321

os.environ['postgre_database'] = "ilens-hfae"
os.environ['postgre_user'] = "hfae"
os.environ['postgre_password'] = "iLens#4321"
os.environ['postgre_host'] = "20.198.97.231"
os.environ['postgre_port'] = "5432"


class Postgres():
    def __init__(self):

        self.conn = psycopg2.connect(
            database=os.environ.get("postgre_database", default=None),
            user=os.environ.get("postgre_user", default=None),
            password=os.environ.get("postgre_password", default=None),
            host=os.environ.get("postgre_host", default=None),
            port=int(os.environ.get("postgre_port", default=None))

        )
        logger.info("Connected to PostgresSQL DB...")
        self.cur = self.conn.cursor()

    def create_table(self, table_name):
        self.cur.execute(
            "CREATE TABLE {table_name}(job_id INT  NOT NULL, file_name TEXT NOT NULL,"
            "site_mac_id TEXT NOT NULL,"
            "start_date DATE NOT NULL,end_date DATE NOT NULL,status TEXT)".format(
                table_name=table_name))
        logger.info("Table created successfully")
        self.conn.commit()

    def delete_records(self, table_name, pipeline_id):
        self.cur.execute("DELETE FROM {table_name} WHERE pipeline_id='{pipeline_id}'".format(table_name=table_name,
                                                                                             pipeline_id=pipeline_id))
        logger.info("Record deleted successfully")
        self.conn.commit()

    def insert_records(self, table_name, job_id, file_name, site_mac_id, start_date, end_date, status):
        try:
            self.cur.execute(
                "INSERT INTO {table_name} (job_id,file_name, site_mac_id,  start_date, end_date, status)"
                "values('{job_id}','{file_name}', '{site_mac_id}', '{start_date}', '{end_date}', "
                "'{status}')"
                    .format(table_name=table_name, job_id=job_id, file_name=file_name,
                            site_mac_id=site_mac_id,
                            start_date=start_date, end_date=end_date, status=status))

            self.conn.commit()
            logger.info('Records Inserted successfully')
        except Exception as e:
            logger.error(f'failed to upload status {file_name}')
            logger.error(e)

    def update_records(self, table_name, file_name, job_id, end_date, status):
        # self.cur.execute("SELECT * from {table_name}".format(table_name=table_name))
        # rows = self.cur.fetchall()
        # for file in file_list:
        # if row[0] == file_list:
        #     ri = row[3] + 1
        try:
            self.cur.execute(
                "UPDATE {table_name} set status = '{status}', end_date = '{end_date}' where job_id = '{job_id}' "
                "and file_name = '{file_name}' "
                    .format(table_name=table_name, file_name=file_name, status=status, end_date=end_date,
                            job_id=job_id))
            self.conn.commit()
            logger.info(f'Records Updated successfully for file {file_name}')
        except Exception as e:
            logger.error(f'failed to upload status {file_name}')
            logger.error(e)

    def show_records(self, table_name):
        self.cur.execute("SELECT * from {table_name}".format(table_name=table_name))
        rows = self.cur.fetchall()
        for row in rows:
            logger.info(row)

    def get_file_names(self, table_name, time_stamp):
        logger.info(
            f"SELECT file_name FROM {table_name} WHERE status in ('ARCHIVE','UNPROCESSED') and start_date >= timestamp '{time_stamp}'")
        self.cur.execute(
            f"SELECT file_name FROM {table_name} WHERE status in ('ARCHIVE','UNPROCESSED') and start_date >= timestamp '{time_stamp}'")
        rows = self.cur.fetchall()
        new_list = []
        for row in rows:
            new_list.append(row[0])
        return new_list

    def query_db(self, query, table_name, main_list, time_stamp):
        logger.info(
            f"SELECT file_name FROM {table_name} WHERE file_name in {query} and start_date >= timestamp '{time_stamp}'")
        self.cur.execute(
            f"SELECT file_name FROM {table_name} WHERE file_name in {query} and start_date >= timestamp '{time_stamp}'")
        rows = self.cur.fetchall()
        for row in rows:
            print(row)
            # try:
            #     logger.info(f"{row[0]} is already in postgres")
            #     main_list.remove(row[0])
            # except:
            #     pass
        return main_list

    def query_file_name(self, file_name, table_name):
        try:
            self.cur.execute(f"SELECT COUNT(file_name) FROM {table_name} WHERE file_name = '{file_name}'")
            rows = self.cur.fetchone()
            return rows[0]
        except:
            return 0

    def close_connection(self):
        self.conn.close()

# pg = Postgres()
# import datetime
# check_for_n_hours = 1
# time_stamp = datetime.datetime.utcnow() - datetime.timedelta(hours=check_for_n_hours)
# pg.get_file_names('hfe_master_file_status',time_stamp)
# # pg.query_db("('WD008A67')",'hfe_master_file_status',[],time_stamp)
# # pg.insert_records(108, 'PreProcessing', 112, 1109, '2020-10-01', '2020-11-10', 'running')
# # pg.delete_records('DEVICEA',108)
# # pg.update_records('DEVICEA',103,'error')
# # pg.show_records('DEVICEA')
# pg.close_connection()
