import uuid
from datetime import datetime, timedelta
from pymongo import DESCENDING
from scripts.common.logsetup import logger
from scripts.common.config import MONGO_DB_OBJ, MONGO_SERVICE_COLL


class PullEvents:

    def __init__(self):
        APP_MONGO_COLLECTION = MONGO_DB_OBJ[MONGO_SERVICE_COLL].find_one({'configId': 'appMongoConfig'}).get('config')
        # print(MONGO_DB_OBJ[APP_MONGO_COLLECTION])
        self.event_logs_collection = MONGO_DB_OBJ[APP_MONGO_COLLECTION['eventLogCollection']]
        self.employee_configuration = MONGO_DB_OBJ[APP_MONGO_COLLECTION['employeeConfiguration']]
        self.testing_collection = MONGO_DB_OBJ[APP_MONGO_COLLECTION['testConfiguration']]

    def fetch_timings(self, from_time, to_time, emp_id):
        first_event = self.event_logs_collection.find_one({'timestamp': {"$gte": from_time, "$lt": to_time},
                                                           'eventMessage.Person ID': emp_id}, {'_id': 0, "frame": 0})
        last_event = self.event_logs_collection.find_one({'timestamp': {"$gte": from_time, "$lt": to_time},
                                                          'eventMessage.Person ID': emp_id}, {'_id': 0, "frame": 0},
                                                         sort=[("timestamp", DESCENDING)])
        employee_name = self.employee_configuration.find_one({'emp_id': emp_id}, {'_id': 0}).get('emp_name')
        return first_event, last_event, employee_name

    def get_attendance(self, from_time, to_time):
        unique_emp_id = [each_person for each_person in
                         self.event_logs_collection.find({'timestamp': {"$gte": from_time, "$lt": to_time}}).distinct(
                             "eventMessage.Person ID")]
        payload = []
        dates = [date for date in self.datetime_range(start=from_time, end=to_time)]
        dates.append(to_time)
        list_of_date_combs = list(zip(dates, dates[1:] + dates[:1]))
        del list_of_date_combs[-1]
        for each_day in list_of_date_combs:
            for each_person in unique_emp_id:
                try:
                    first_event, last_event, employee_name = self.fetch_timings(each_day[0], each_day[1], each_person)
                    payload.append({
                        "employee_name": employee_name,
                        "employee_id": each_person,
                        "login": first_event.get('timestamp'),
                        "logout": last_event.get('timestamp')
                    })
                except Exception as e:
                    logger.error(e)
        return payload

    def create_event_records(self, emp_id, event_timestamps):

        for i in event_timestamps:
            data = {'id': str(uuid.uuid1()).split('-')[0], 'emp_id': emp_id, 'timestamp': i}
            self.testing_collection.insert(data)
        return True

    @staticmethod
    def datetime_range(start=None, end=None):
        span = end - start
        for i in range(span.days + 1):
            yield start + timedelta(days=i)


if __name__ == '__main__':
    d = PullEvents().get_attendance(datetime(2020, 6, 26, 14, 00, 00, 776000),
                                    datetime(2020, 6, 26, 15, 00, 00, 776000))
    # empid = "2271"
    # timestamps = [datetime.today(), datetime.today()]
    # d = PullEvents().create_event_records(empid,timestamps)
    for each in d:
        print(each)
