import sys
from datetime import datetime
from pymongo import MongoClient
import json
import os


def licence_validator(payload):
    try:
        dt = parser.parse(payload['valid_till'])
        now = datetime.now()
        if (now > dt):
            sys.stdout.write("Licence Expired \n".format())
            sys.stdout.flush()
            return False
        return True
    except KeyError as e:
        sys.stderr.write("Error loading licence")
        return False


def get_config_from_mongo(mongo_uri, dbname, basecollection,
                          key, value):
    mongo = MongoClient(mongo_uri)

    db = mongo[dbname]
    config = db[basecollection].find_one({key: value}, {"_id": False})
    return config


# MAIN_OS_VARIABLE = {
# 	"MONGO_URI": "mongodb://svc-ilens:svc2345@192.168.1.47:21017",
# 	"MONGO_DB": "ilens_wps",
# 	"MONGO_COLL": "serviceConfiguration"
# }
MAIN_OS_VARIABLE = json.loads(os.environ.get('config'))
if MAIN_OS_VARIABLE is None:
    sys.stderr.write("Configuration not found...")
    sys.stderr.write("Exiting....")
    sys.exit(1)

MONGO_URI = MAIN_OS_VARIABLE['MONGO_URI']
MONGO_SERVICE_DB = MAIN_OS_VARIABLE['MONGO_DB']
MONGO_SERVICE_COLL = MAIN_OS_VARIABLE['MONGO_COLL']

MONGO_DB_OBJ = MongoClient(MONGO_URI)[MONGO_SERVICE_DB]
HOST_CONFIG = MONGO_DB_OBJ[MONGO_SERVICE_COLL].find_one({'configId': 'hostConfig'}).get('config')

DATA_PATH = MAIN_OS_VARIABLE.get('dataPath', os.path.join(os.getcwd(), "data".format()))
sys.stderr.write("Loading data from {} \n".format(DATA_PATH))
LOG_LEVEL = MAIN_OS_VARIABLE.get("LOG_LEVEL", "DEBUG").upper()
LOG_HANDLER_NAME = MAIN_OS_VARIABLE.get("logHandlerName", "ilens-engine")

BASE_LOG_PATH = MAIN_OS_VARIABLE.get('baseLogPath',
                                     os.path.join(os.getcwd(), "logs".format()))

if not os.path.isdir(BASE_LOG_PATH):
    os.mkdir(BASE_LOG_PATH)

if not os.path.isdir(DATA_PATH):
    os.mkdir(DATA_PATH)
