import uuid
from datetime import datetime, date
import random
import sqlalchemy as sa, json
from sqlalchemy import func, desc
from sqlalchemy import cast, Date
from sqlalchemy.orm import sessionmaker
from sqlalchemy.ext.declarative import declarative_base
from scripts.common.logsetup import logger
from scripts.common.config import MONGO_DB_OBJ, MONGO_SERVICE_COLL

Base = declarative_base()

MYSQL_CONFIG = MONGO_DB_OBJ[MONGO_SERVICE_COLL].find_one({'configId': 'msserver'}).get('config')


class configurations(Base):
    __tablename__ = MYSQL_CONFIG['config_table']
    id = sa.Column(sa.VARCHAR(10), nullable=False, primary_key=True)
    job_run_date = sa.Column(sa.DATETIME, nullable=False)
    auto_update = sa.Column(sa.BINARY, nullable=False)
    shift_hours = sa.Column(sa.INT, nullable=False)
    group_event_period_seconds = sa.Column(sa.INT, nullable=False)
    over_time_hours = sa.Column(sa.INT, nullable=True)


class shift_time(Base):
    __tablename__ = MYSQL_CONFIG['shift_time']
    ShiftType = sa.Column(sa.VARCHAR(8), nullable=False, primary_key=True)
    ShiftPattern = sa.Column(sa.VARCHAR(8), nullable=False, primary_key=True)
    InTime = sa.Column(sa.VARCHAR(5), nullable=True)
    OutTime = sa.Column(sa.VARCHAR(5), nullable=True)
    RestDayFix = sa.Column(sa.VARCHAR(1), nullable=True)
    RestDay1 = sa.Column(sa.VARCHAR(12), nullable=True)
    RestDay2 = sa.Column(sa.VARCHAR(12), nullable=True)
    Category = sa.Column(sa.VARCHAR(5), nullable=True)
    Remarks = sa.Column(sa.VARCHAR(50), nullable=True)


class Tra_attendance(Base):
    __tablename__ = MYSQL_CONFIG['tra_attendance']
    F_Tbl_row_id = sa.Column(sa.BIGINT, primary_key=True)
    F_Tbl_Emp_Code = sa.Column(sa.NVARCHAR(10), nullable=False)
    F_Tbl_P_TIME = sa.Column(sa.DATETIME, nullable=True)
    F_Tbl_dtpunched = sa.Column(sa.DATETIME, nullable=False)
    F_Tbl_Intm = sa.Column(sa.DATETIME, nullable=True)
    F_Tbl_In1 = sa.Column(sa.DATETIME, nullable=True)
    F_Tbl_Out1 = sa.Column(sa.DATETIME, nullable=True)
    F_Tbl_In2 = sa.Column(sa.DATETIME, nullable=True)
    F_Tbl_Out2 = sa.Column(sa.DATETIME, nullable=True)
    F_Tbl_Int3 = sa.Column(sa.DATETIME, nullable=True)
    F_Tbl_Out3 = sa.Column(sa.DATETIME, nullable=True)
    F_Tbl_Int4 = sa.Column(sa.DATETIME, nullable=True)
    F_Tbl_Out4 = sa.Column(sa.DATETIME, nullable=True)
    F_Tbl_Outtm = sa.Column(sa.DATETIME, nullable=True)
    F_Tbl_Sh_Code = sa.Column(sa.NVARCHAR(10), nullable=True)
    F_Tbl_Verified = sa.Column(sa.BINARY, nullable=True)
    F_Tbl_WorkHours = sa.Column(sa.INT, nullable=True)
    F_Tbl_ShiftHours = sa.Column(sa.INT, nullable=True)
    F_Tbl_CrBy = sa.Column(sa.NVARCHAR(10), nullable=False)
    F_Tbl_CrDate = sa.Column(sa.DATETIME, nullable=False)
    F_Tbl_MoBy = sa.Column(sa.NVARCHAR(10), nullable=False)
    F_Tbl_MoDate = sa.Column(sa.DATETIME, nullable=False)
    F_Tbl_SentToOracle = sa.Column(sa.BINARY, nullable=True)


class ShiftRoaster(Base):
    __tablename__ = MYSQL_CONFIG['shiftRoaster']
    # id = sa.Column(sa.BIGINT, nullable=False, default=lambda: random.getrandbits(32), primary_key=True)
    MonthName = sa.Column(sa.VARCHAR(10), nullable=False, primary_key=True)
    ShiftType = sa.Column(sa.VARCHAR(10), nullable=False, primary_key=True)
    ShiftPattern = sa.Column(sa.VARCHAR(10), nullable=True)
    Day1 = sa.Column(sa.CHAR(3), nullable=True)
    Day2 = sa.Column(sa.CHAR(3), nullable=True)
    Day3 = sa.Column(sa.CHAR(3), nullable=True)
    Day4 = sa.Column(sa.CHAR(3), nullable=True)
    Day5 = sa.Column(sa.CHAR(3), nullable=True)
    Day6 = sa.Column(sa.CHAR(3), nullable=True)
    Day7 = sa.Column(sa.CHAR(3), nullable=True)
    Day8 = sa.Column(sa.CHAR(3), nullable=True)
    Day9 = sa.Column(sa.CHAR(3), nullable=True)
    Day10 = sa.Column(sa.CHAR(3), nullable=True)
    Day11 = sa.Column(sa.CHAR(3), nullable=True)
    Day12 = sa.Column(sa.CHAR(3), nullable=True)
    Day13 = sa.Column(sa.CHAR(3), nullable=True)
    Day14 = sa.Column(sa.CHAR(3), nullable=True)
    Day15 = sa.Column(sa.CHAR(3), nullable=True)
    Day16 = sa.Column(sa.CHAR(3), nullable=True)
    Day17 = sa.Column(sa.CHAR(3), nullable=True)
    Day18 = sa.Column(sa.CHAR(3), nullable=True)
    Day19 = sa.Column(sa.CHAR(3), nullable=True)
    Day20 = sa.Column(sa.CHAR(3), nullable=True)
    Day21 = sa.Column(sa.CHAR(3), nullable=True)
    Day22 = sa.Column(sa.CHAR(3), nullable=True)
    Day23 = sa.Column(sa.CHAR(3), nullable=True)
    Day24 = sa.Column(sa.CHAR(3), nullable=True)
    Day25 = sa.Column(sa.CHAR(3), nullable=True)
    Day26 = sa.Column(sa.CHAR(3), nullable=True)
    Day27 = sa.Column(sa.CHAR(3), nullable=True)
    Day28 = sa.Column(sa.CHAR(3), nullable=True)
    Day29 = sa.Column(sa.CHAR(3), nullable=True)
    Day30 = sa.Column(sa.CHAR(3), nullable=True)
    Day31 = sa.Column(sa.CHAR(3), nullable=True)
    # i = 1
    # x = 'Date'
    # while i < 32:
    #     # print(i)
    #     name = x + str(i)
    #     name = sa.Column(sa.CHAR, length=3, nullable=True)
    #     i += 1


class IndShiftRoaster(Base):
    __tablename__ = MYSQL_CONFIG['IndShiftRoaster']
    # id = sa.Column(sa.BIGINT, nullable=False, default=lambda: random.getrandbits(32), primary_key=True)
    EmpID = sa.Column(sa.VARCHAR(10), nullable=False, primary_key=True)
    MonthName = sa.Column(sa.VARCHAR(10), nullable=False, primary_key=True)
    ShiftType = sa.Column(sa.VARCHAR(10), nullable=True)
    ShiftPattern = sa.Column(sa.VARCHAR(10), nullable=True)
    Day1 = sa.Column(sa.CHAR(6), nullable=True)
    Day2 = sa.Column(sa.CHAR(6), nullable=True)
    Day3 = sa.Column(sa.CHAR(6), nullable=True)
    Day4 = sa.Column(sa.CHAR(6), nullable=True)
    Day5 = sa.Column(sa.CHAR(6), nullable=True)
    Day6 = sa.Column(sa.CHAR(6), nullable=True)
    Day7 = sa.Column(sa.CHAR(6), nullable=True)
    Day8 = sa.Column(sa.CHAR(6), nullable=True)
    Day9 = sa.Column(sa.CHAR(6), nullable=True)
    Day10 = sa.Column(sa.CHAR(6), nullable=True)
    Day11 = sa.Column(sa.CHAR(6), nullable=True)
    Day12 = sa.Column(sa.CHAR(6), nullable=True)
    Day13 = sa.Column(sa.CHAR(6), nullable=True)
    Day14 = sa.Column(sa.CHAR(6), nullable=True)
    Day15 = sa.Column(sa.CHAR(6), nullable=True)
    Day16 = sa.Column(sa.CHAR(6), nullable=True)
    Day17 = sa.Column(sa.CHAR(6), nullable=True)
    Day18 = sa.Column(sa.CHAR(6), nullable=True)
    Day19 = sa.Column(sa.CHAR(6), nullable=True)
    Day20 = sa.Column(sa.CHAR(6), nullable=True)
    Day21 = sa.Column(sa.CHAR(6), nullable=True)
    Day22 = sa.Column(sa.CHAR(6), nullable=True)
    Day23 = sa.Column(sa.CHAR(6), nullable=True)
    Day24 = sa.Column(sa.CHAR(6), nullable=True)
    Day25 = sa.Column(sa.CHAR(6), nullable=True)
    Day26 = sa.Column(sa.CHAR(6), nullable=True)
    Day27 = sa.Column(sa.CHAR(6), nullable=True)
    Day28 = sa.Column(sa.CHAR(6), nullable=True)
    Day29 = sa.Column(sa.CHAR(6), nullable=True)
    Day30 = sa.Column(sa.CHAR(6), nullable=True)
    Day31 = sa.Column(sa.CHAR(6), nullable=True)


class Event(Base):
    __tablename__ = MYSQL_CONFIG['table']
    id = sa.Column(sa.Integer, primary_key=True)
    employee_name = sa.Column(sa.Text)
    employee_id = sa.Column(sa.Text)
    login = sa.Column(sa.DateTime)
    logout = sa.Column(sa.DateTime)


class SQLiteHandler:
    def __init__(self):
        logger.info("starting sql engine")
        self.MYSQL_CONFIG = MONGO_DB_OBJ[MONGO_SERVICE_COLL].find_one({'configId': 'msserver'}).get('config')
        self.path = self.get_path()
        self.session = self.db_connect()
        self.final_dict = {}
        self.final_dict2 = {}
        self.final_dict3 = {}
        self.update_dict = {}
        self.punch_dict = {}
        self.punch_list = []
        self.config = {}

    def get_path(self):
        return "{}/{}".format(self.MYSQL_CONFIG['uri'], self.MYSQL_CONFIG['database'])

    def db_connect(self):
        logger.info("Creating db in {}".format(self.path))
        engine = sa.create_engine(self.path)
        Base.metadata.create_all(engine)
        session = sessionmaker(engine)
        return session()

    def add_event_to_db(self, data):
        logger.info("Adding event data...")
        res = self.session.query(Event).filter(Event.employee_id == data['employee_id']).filter(
            func.DATE(Event.login) == data['login'].date()).filter(func.DATE(Event.logout) == data['logout'].date())
        is_present = False
        for each in res:
            is_present = True
            datas = self.session.query(Event).filter(Event.employee_id == data['employee_id']).filter(
                func.DATE(Event.login) == data['login'].date()).filter(
                func.DATE(Event.logout) == data['logout'].date())[0]
            logger.info("Updating {}, {}, {}, {} with {}, {}, {}, {}".format(datas.employee_id, datas.employee_name,
                                                                             datas.login, datas.logout,
                                                                             data['employee_id'], data['employee_name'],
                                                                             data['login'], data['logout']))
            self.session.query(Event).filter(Event.employee_id == data['employee_id']).filter(
                func.DATE(Event.login) == data['login'].date()).filter(
                func.DATE(Event.logout) == data['logout'].date()).update({"logout": data['logout']},
                                                                         synchronize_session=False)
            self.session.commit()
        if not is_present:
            logger.info("User not present, adding now: {}".format(data['employee_name']))
            self.session.add(self.add_event(data))
            self.session.commit()

    def add_to_db(self, data1):
        for data in data1:

            try:
                # print('----', func.DATE(Tra_attendance.F_Tbl_dtpunched))
                # print(date.today())
                res = self.session.query(Tra_attendance).filter(Tra_attendance.F_Tbl_Emp_Code == data['emp_id']).filter(
                    cast(Tra_attendance.F_Tbl_dtpunched, Date) == data['punch_date']).count()
                print(res)
                if res:
                    # res1 = self.session.query(Tra_attendance).filter(Tra_attendance.F_Tbl_Emp_Code == key).filter(
                    #     func.DATE(Tra_attendance.F_Tbl_dtpunched) == date.today())
                    # for record in res1:
                    #     self.update_dict = record.__dict__
                    # print(self.update_dict)
                    logger.info("User present, updating now: {}".format(data['emp_id']))
                    update_dict = data['update_values']
                    self.session.query(Tra_attendance).filter(
                        Tra_attendance.F_Tbl_Emp_Code == data['emp_id']).filter(
                        cast(Tra_attendance.F_Tbl_dtpunched, Date) == data['punch_date']).update(
                        update_dict,
                        synchronize_session=False)
                    self.session.commit()
                else:
                    logger.info("User not present, adding now: {}".format(data['emp_id']))
                    self.session.add(self.row_to_be_inserted(data, data['emp_id']))
                    self.session.commit()
            except Exception:
                self.session.rollback()
                logger.error(f"Failed for {data['emp_id']} id", exc_info=True)

    def get_events(self, from_time, to_time):
        db_records = self.session.query(Event.employee_id, Event.employee_name, Event.login, Event.logout).filter(
            Event.login > from_time, Event.logout < to_time)
        payload = []
        for each_event in db_records:
            payload.append({
                "employee_id": each_event[0],
                "employee_name": each_event[1],
                "login": each_event[2],
                "logout": each_event[3]
            })
        return payload

    def getpunchDateData(self, id):

        subqry = self.session.query(func.max(Tra_attendance.F_Tbl_dtpunched)).filter(
            Tra_attendance.F_Tbl_Emp_Code == id)
        records = self.session.query(Tra_attendance).filter(Tra_attendance.F_Tbl_Emp_Code == id,
                                                            Tra_attendance.F_Tbl_dtpunched == subqry)
        # records = self.session.query(Tra_attendance).filter(Tra_attendance.F_Tbl_Emp_Code == id).order_by(
        #     desc(Tra_attendance.F_Tbl_dtpunched).limit(1))
        count = self.session.query(Tra_attendance).filter(Tra_attendance.F_Tbl_Emp_Code == id,
                                                          Tra_attendance.F_Tbl_dtpunched == subqry).count()
        print(count)
        if count:
            logger.info("found match with id and punch date: {}".format(id))
            status = True
            for each in records:
                self.punch_dict = each.__dict__
            # print(self.punch_dict)
            # print(len(self.punch_list))
            return status, self.punch_dict
        else:
            status = False
            return status, None

    def delpunchDateData(self, punch_date, id):
        count = self.session.query(Tra_attendance).filter(Tra_attendance.F_Tbl_Emp_Code == id).filter(
            cast(Tra_attendance.F_Tbl_dtpunched, Date) == punch_date).count()
        print(count)
        if count:
            logger.info("found match with id and punch date deleting it: {}, {}".format(id, punch_date))
            status = True
            del_record = self.session.query(Tra_attendance).filter(Tra_attendance.F_Tbl_Emp_Code == id).filter(
                cast(Tra_attendance.F_Tbl_dtpunched, Date) == punch_date).one()
            self.session.delete(del_record)
            self.session.commit()
            return status
        else:
            return False

    def getConfig(self):
        records = self.session.query(configurations).filter(
            configurations.id == self.session.query(func.max(configurations.id)))
        # print(records)
        for record in records:
            # print(record)
            self.config = record.__dict__
        return self.config

    def insertindshift(self, row):
        for i in row:
            if int(i) < 51:
                self.session.add(self.indshiftinsert(i, 'GS'))
                self.session.commit()
            else:
                self.session.add(self.indshiftinsert(i, 'SHB'))
                self.session.commit()

    def shift_window(self, emp_id, punch_date):
        # print(datetime.now().date())
        x = str(punch_date)
        x = x.split('-')
        column = 'Day' + str(x[-1])
        month = punch_date.strftime("%b")
        year = punch_date.strftime("%y")
        print(month.upper() + year)
        monthname = month.upper() + year
        # print(column)
        # db_records = self.session.query(IndShiftRoaster).filter(IndShiftRoaster.EmpID == emp_id)
        records = self.session.query(IndShiftRoaster).filter(IndShiftRoaster.EmpID == emp_id,
                                                             IndShiftRoaster.MonthName == monthname)
        for record in records:
            self.final_dict = record.__dict__
            # print(record.__dict__)
        shiftType = self.final_dict[column]
        # shiftType = shiftType.lstrip()
        # print(shiftType)
        records2 = self.session.query(ShiftRoaster).filter(ShiftRoaster.ShiftType == shiftType)
        for record in records2:
            self.final_dict2 = record.__dict__
            # print(record.__dict__)
        roasterType = self.final_dict2[column]
        # print(roasterType)
        shift = shiftType.strip()
        roaster = roasterType.strip()
        print(shift)

        records3 = self.session.query(shift_time).filter(shift_time.ShiftType == shift,
                                                         shift_time.ShiftPattern == roaster)
        for record in records3:
            self.final_dict3 = record.__dict__
            print(record.__dict__)
        # self.punch_list.append(self.final_dict3)
        # in_time = final_dict3['']
        return self.final_dict3

    @staticmethod
    def add_event(data):
        return Event(
            employee_name=data['employee_name'],
            employee_id=data['employee_id'],
            login=data['login'],
            logout=data['logout'],
        )

    @staticmethod
    def indshiftinsert(i, type):
        return IndShiftRoaster(
            EmpID=str(i),
            MonthName='JUL20',
            ShiftType=type,
            ShiftPattern=type,
            Day1=type,
            Day2=type,
            Day3=type,
            Day4=type,
            Day5=type,
            Day6=type,
            Day7=type,
            Day8=type,
            Day9=type,
            Day10=type,
            Day11=type,
            Day12=type,
            Day13=type,
            Day14=type,
            Day15=type,
            Day16=type,
            Day17=type,
            Day18=type,
            Day19=type,
            Day20=type,
            Day21=type,
            Day22=type,
            Day23=type,
            Day24=type,
            Day25=type,
            Day26=type,
            Day27=type,
            Day28=type,
            Day29=type,
            Day30=type,
            Day31=type
        )

    @staticmethod
    def row_to_be_inserted(data, key):
        return Tra_attendance(
            F_Tbl_Emp_Code=data['emp_id'],
            F_Tbl_P_TIME=data['update_values'].get('F_Tbl_Intm', None),
            F_Tbl_dtpunched=data['punch_date'],
            F_Tbl_Intm=data['update_values'].get('F_Tbl_Intm', None),
            F_Tbl_In1=data['update_values'].get('F_Tbl_In1', None),
            F_Tbl_Out1=data['update_values'].get('F_Tbl_Out1', None),
            F_Tbl_In2=data['update_values'].get('F_Tbl_In2', None),
            F_Tbl_Out2=data['update_values'].get('F_Tbl_Out2', None),
            F_Tbl_Int3=data['update_values'].get('F_Tbl_Int3', None),
            F_Tbl_Out3=data['update_values'].get('F_Tbl_Out3', None),
            F_Tbl_Int4=data['update_values'].get('F_Tbl_Int4', None),
            F_Tbl_Out4=data['update_values'].get('F_Tbl_Out4', None),
            F_Tbl_Outtm=data['update_values'].get('F_Tbl_Outtm', None),
            # F_Tbl_Sh_Code=data[''],
            # F_Tbl_Verified=,
            # F_Tbl_WorkHours=data[''],
            # F_Tbl_ShiftHours=data[''],
            F_Tbl_CrBy='',
            F_Tbl_CrDate=datetime.today(),
            F_Tbl_MoBy='MI',
            F_Tbl_MoDate=datetime.today(),
            # F_Tbl_SentToOracle=,
        )


if __name__ == '__main__':
    d = SQLiteHandler()
    d.add_event_to_db(
        {
            "employee_name": "sajadsd",
            "employee_id": "4343",
            "login": datetime.now(),
            'logout': datetime.now()
        }
    )
    print(d.get_events(datetime(2020, 6, 25, 10, 00, 49, 776000), datetime(2020, 6, 25, 11, 23, 49, 776000)))
