import os
from collections import namedtuple

os.environ['config'] = '{"MONGO_URI": "mongodb://svc-ilens:svc2345@192.168.0.220:21017", "MONGO_DB":"ilens_wps", ' \
                       '"MONGO_COLL": "serviceConfiguration"} '
from scripts.pull_docs_mongo import PullEvents
from scripts.sqlite_ingestor import SQLiteHandler
from scripts.cron_job import CRON
from scripts.common.config import MONGO_DB_OBJ, MONGO_SERVICE_COLL, HOST_CONFIG
from datetime import datetime, timedelta
from scripts.common.logsetup import logger
from scripts.cron_job import *
from datetime import datetime
from dateutil import tz

get_in_out_dt_output = namedtuple("output", "dt_in_time dt_out_time punch_date")


def create_db_obj():
    """Creates and returns the database object
    also initialise schemas in the data
    Returns:
        SQLiteHandler: Database object
    """
    db_obj = CRON()
    return db_obj


def insert_records(msserver_obj, data):

    # METHOD 1: Hardcode zones:
    from_zone = tz.gettz('UTC')
    to_zone = tz.gettz('Asia/Kolkata')
    print(to_zone)
    utc = datetime.utcnow()
    utc = utc.replace(tzinfo=from_zone)
    # Convert time zone
    central = utc.astimezone(to_zone)
    print(central)
    data = {
        "job_run_date": central,
        "auto_update": 1,
        "shift_hours": 8,
        "group_event_period_seconds": 300,
        "over_time_hours": 3,
        "job_interval_minutes": 15
    }

    x = msserver_obj.insert_records(data)
    print(x)
    return x


def add(msserver_obj, date):
    date = datetime.today()
    msserver_obj.insertConfigTime(date)


def main():
    """main function
    """
    msserver_obj = create_db_obj()  # Vamshi
    insert_records(msserver_obj, '')


if __name__ == '__main__':
    main()
#
# msserver_obj = create_db_obj()
# # get_config(msserver_obj)
# # insert_records(msserver_obj, '')
# # msserver_obj.insertConfigTime()
