import os
import uuid
from datetime import datetime, date
import random
import sqlalchemy as sa, json
from sqlalchemy import func, desc
from sqlalchemy import cast, Date
from sqlalchemy.orm import sessionmaker
from sqlalchemy.ext.declarative import declarative_base
from scripts.common.logsetup import logger
from scripts.common.config import MONGO_DB_OBJ, MONGO_SERVICE_COLL
from datetime import timedelta
from dateutil import tz
Base = declarative_base()

MYSQL_CONFIG = MONGO_DB_OBJ[MONGO_SERVICE_COLL].find_one({'configId': 'msserver'}).get('config')


class configurations(Base):
    __tablename__ = MYSQL_CONFIG['config_table']
    # id = sa.Column(sa.VARCHAR(10), nullable=False, primary_key=True)
    id = sa.Column(sa.Integer, primary_key=True)
    job_run_date = sa.Column(sa.DATETIME, nullable=False)
    auto_update = sa.Column(sa.INT, nullable=False)
    shift_hours = sa.Column(sa.INT, nullable=False)
    group_event_period_seconds = sa.Column(sa.INT, nullable=False)
    over_time_hours = sa.Column(sa.INT, nullable=False)
    job_interval_minutes = sa.Column(sa.INT, nullable=False)


class CRON:
    def __init__(self):
        logger.info("starting sql engine")
        self.MYSQL_CONFIG = MONGO_DB_OBJ[MONGO_SERVICE_COLL].find_one({'configId': 'msserver'}).get('config')
        self.path = self.get_path()
        self.session = self.db_connect()
        self.final_dict = {}
        self.config_list = []
        self.config = {}

    def get_path(self):
        return "{}/{}".format(self.MYSQL_CONFIG['uri'], self.MYSQL_CONFIG['database'])

    def db_connect(self):
        logger.info("Creating db in {}".format(self.path))
        engine = sa.create_engine(self.path)
        Base.metadata.create_all(engine)
        session = sessionmaker(engine)
        return session()

    def getConfig(self):
        del_record = self.session.query(configurations).filter(
            cast(configurations.job_run_date, Date) <= (date.today() - timedelta(days=7)))
        del_record.delete(synchronize_session=False)
        # self.session.delete(del_record)
        self.session.commit()
        records = self.session.query(configurations).filter(
            configurations.id == self.session.query(func.max(configurations.id)))
        # print(records)
        for record in records:
            # print(record)
            self.config = record.__dict__
        return self.config

    def insert_records(self, data):

        res = self.session.query(configurations).count()
        # print(res)
        logger.info("total records in config {}".format(res))
        if res == 0:
            self.session.add(self.insert(data))
            self.session.commit()
        else:
            data = self.getConfig()
            # from_zone = tz.gettz('UTC')
            # to_zone = tz.gettz('Asia/Kolkata')
            # print(to_zone)
            # utc = datetime.utcnow()
            # utc = utc.replace(tzinfo=from_zone)
            # # Convert time zone
            # localtimenow = utc.astimezone(to_zone)
            localtimenow = datetime.now()
            # print(data)
            check = (data['job_run_date'] + timedelta(minutes=data['job_interval_minutes']))
            logger.info("Previous job run time and job interval are {}, {}".format(data['job_run_date'],data['job_interval_minutes']))
            # print(check,localtimenow)
            if data['auto_update'] == 1 and check < localtimenow:
                # print(data['job_run_date'], data['job_interval_minutes'])
                data['job_run_date'] = localtimenow
                self.session.add(self.insert(data))
                self.session.commit()
        return True

    def insertConfigTime(self, job_date):
        data = {
            "job_run_date": job_date,
            "auto_update": MYSQL_CONFIG['auto_update'],
            "shift_hours": MYSQL_CONFIG['shift_hours'],
            "group_event_period_seconds": MYSQL_CONFIG['group_event_period_seconds'],
            "over_time_hours": MYSQL_CONFIG['over_time_hours'],
            "job_interval_minutes": MYSQL_CONFIG['job_interval_minutes']
        }
        self.session.add(self.insert(data))
        self.session.commit()

    @staticmethod
    def insert(data):
        return configurations(
            job_run_date=data['job_run_date'],
            auto_update=data['auto_update'],
            shift_hours=data['shift_hours'],
            group_event_period_seconds=data['group_event_period_seconds'],
            over_time_hours=data['over_time_hours'],
            job_interval_minutes=data['job_interval_minutes']
        )


if __name__ == '__main__':
    d = CRON()
    # x = d.get_records()
    # print(x)
