import os
from collections import namedtuple

os.environ[
    'config'] = '{"MONGO_URI": "mongodb://svc-ilens:svc2345@192.168.0.220:21017", "MONGO_DB":"ilens_wps", ' \
                '"MONGO_COLL": "serviceConfiguration"} '
from scripts.pull_docs_mongo import PullEvents
from scripts.sqlite_ingestor import SQLiteHandler
from scripts.common.config import MONGO_DB_OBJ, MONGO_SERVICE_COLL, HOST_CONFIG
from datetime import datetime, timedelta
from scripts.common.logsetup import logger
from scripts.sqlite_ingestor import *
get_in_out_dt_output = namedtuple("output", "dt_in_time dt_out_time punch_date")

def create_db_obj():
    """Creates and returns the database object
    also initialise schemas in the data
    Returns:
        SQLiteHandler: Database object
    """
    db_obj = SQLiteHandler()
    return db_obj


def init_mongo():
    """Create and return mongo db object

    Returns:
        PullEvents: mongoDB interface
    """
    pull_events = None
    return pull_events


def fetch_from_mongo(mongo_obj):
    """fetch events data from mongo DB

    Args:
        mongo_obj (PullEvents): interface to mongo db

    Returns:
        Dict: {
      <employee_id>: {
                       "employee_name": employee_name,
                       "events":timestamps
                    }
    }
    """
    output = None
    return output


def get_shift_window(msserver_obj, emp_id, punch_dates):
    """return a list of get_in_out_dt_output object

    Args:
        msserver_obj
        punch_dates (list): list of datetime objects

    Returns:
        output (list): 'get_in_out_dt_output'
    """
    emp_id = '51'
    output = []
    punch_dates = [date.today(),date.today()]
    for punch_date in punch_dates:
        val = msserver_obj.shift_window(emp_id, punch_date)
        dt_in_time = str(val['InTime']).replace(':', '')[:4]
        dt_out_time = str(val['OutTime']).replace(':', '')[:4]
        if int(dt_out_time) - int(dt_in_time) > 0:
            dt_in_time = datetime.strptime(str(punch_date).replace('-','') + dt_in_time,'%Y%m%d%H%M')
            dt_out_time = datetime.strptime(str(punch_date).replace('-','') + dt_out_time,'%Y%m%d%H%M')
        else:
            out_punch_date = punch_date + timedelta(days=1)
            dt_in_time = datetime.strptime(str(punch_date).replace('-', '') + dt_in_time, '%Y%m%d%H%M')
            dt_out_time = datetime.strptime(str(out_punch_date).replace('-', '') + dt_out_time, '%Y%m%d%H%M')
        # get_in_out_dt_output = namedtuple("output", "dt_in_time dt_out_time punch_date")
        output.append(get_in_out_dt_output(dt_in_time,dt_out_time,punch_date))
    print(output)
    return None

# def get_shift_window(data, msserver_obj, punch_date):
#     """Get shift timings for all the employees
#     Args:
#         data (Dict): output of `fetch_from_mongo` method
#         msserver_obj (SQLiteHandler): interface to msserver
#
#     Returns:
#         Dict: {
#       <employee_id>: {
#                        "employee_name": employee_name,
#                        "events":timestamps
#                        "shift_timings":{
#                                     "in_time":<>,
#                                     "out_time":<>
#                                         }
#                     }
#     """
#     Result = {
#
#     }
#     data = {"50": {"employee_name": "vamshi", "events": "timestamps"}
#             }
#     # print(2271)
#     punch_date = datetime.now().date()
#     shift = {
#         "shift_timings": {
#             'Date': datetime.today().date(),
#             "in_time": '',
#             "out_time": ''
#         }
#     }
#     for key, vale in data.items():
#         val = msserver_obj.shift_window(key, punch_date)
#         # print(val)
#         shift['shift_timings']['in_time'] = str(val['InTime']).replace(':', '')[:4]
#         shift['shift_timings']['out_time'] = str(val['OutTime']).replace(':', '')[:4]
#         # print(val)
#         data[key]['shift_timings'] = shift['shift_timings']
#     print(data)
#     return data


def filter_records(data):
    """filter records
    1. Remove all the records that occur in X time period within each other (2 mins)
    2. Flag entry record(first) and Flag exit record (last)
    3. Fill everything in between
    Args:
        data (Dict): Output of `get_shift_window` method  
    Returns:
        Dict:{ <employee_id>: {
                       "employee_name": employee_name,
                       "events":timestamps
                       "shift_timings":{
                                    "in_time":<>,
                                    "out_time":<>
                                        }
                        "F_Tbl_Intm":<>,
                        "F_Tbl_In1"	:<>,
                        "F_Tbl_Out1"	:<>,
                        "F_Tbl_In2"	:<>,
                        "F_Tbl_Out2"	:<>,
                        "F_Tbl_In3":<>,
                        "F_Tbl_Out3"	:<>,
                        "F_Tbl_In4"	:<>,
                        "F_Tbl_Out4"	:<>,
                        "F_Tbl_Outtm":<>
                    }
    }
    """
    return data


def insert_data(data, msserver_obj):
    """Insert data into MSserver

    Args:
        data (Dict): output from filter records
        msserver (SQLiteHandler): interface to Msserver
    """
    data = [{
        "emp_id":"1",
        "employee_name": "vamshi-1",
        "events": "",
        "shift_timings": {
            "in_time": datetime.today(),
            "out_time": datetime.today()
        },
        'update': True,
        'insert': True,
        'punch_date': date.today(),
        'update_values': {
            "F_Tbl_Intm": datetime.today(),
            "F_Tbl_In1": datetime.today(),
            "F_Tbl_Out1": datetime.today(),
            "F_Tbl_In2": datetime.today(),
            "F_Tbl_Out2": datetime.today(),
            "F_Tbl_Int3": datetime.today(),
            "F_Tbl_Out3": datetime.today(),
            "F_Tbl_Int4": datetime.today(),
            "F_Tbl_Out4": datetime.today(),
            "F_Tbl_Outtm": datetime.today()
        }
    },
        {
            "emp_id": "2",
            "employee_name": "vamshi",
            "events": "",
            "shift_timings": {
                "in_time": datetime.today(),
                "out_time": datetime.today()
            },
            'update': True,
            'insert': True,
            'punch_date': date.today(),
            'update_values': {
                "F_Tbl_Intm": datetime.today(),
                "F_Tbl_In1": datetime.today(),
                "F_Tbl_Out1": datetime.today(),
                "F_Tbl_In2": datetime.today(),
                "F_Tbl_Out2": datetime.today(),
                "F_Tbl_Int3": datetime.today(),
                "F_Tbl_Out3": datetime.today(),
                "F_Tbl_Int4": datetime.today(),
                "F_Tbl_Out4": datetime.today(),
                "F_Tbl_Outtm": datetime.today()
            }
        }
    ]
    print(date.today() - timedelta(days=1))
    val = msserver_obj.add_to_db(data)
    return None


def del_employee_for_punch_date(msserver_obj, id, punchTime):
    found = False
    punchTime = date.today()
    id = "1"
    found = msserver_obj.delpunchDateData(punchTime, id)
    if found:
        return "Deleted"
    else:
        return "No Record Found"


def indshift(msserver_obj):
    i = 1
    row = []
    while (i < 101):
        row.append(i)
        i += 1
    print(row)
    msserver_obj.insertindshift(row)


def get_config(msserver_obj):
    """gets the most recently inserted row in the configuration
    Args:
        msserver_obj (SQLiteHandler): db object

    Returns:
        dict : {
            job_run_date :
            auto_update :
            shift_hours :
            over_time_hours :
        }
    """
    config = msserver_obj.getConfig()
    print(config)
    return config


def get_data_for_punch_date(msserver_obj, id, punchTime):
    """[summary]

    Args:
        msserver_obj ([type]): [description]
        id ([type]): [description]
        punchTime ([type]): [description]

    Returns: tuple: found(Boolean):(True if record found else False), row (Dict object if row found else None) True {
    '_sa_instance_state': <sqlalchemy.orm.state.InstanceState object at 0x0000020994F1A488>, 'F_Tbl_dtpunched':
    datetime.datetime(2020, 7, 11, 14, 50, 59), 'F_Tbl_In4': datetime.datetime(2020, 7, 11, 15, 41, 25),
    'F_Tbl_CrBy': '', 'F_Tbl_Intm': datetime.datetime(2020, 7, 11, 15, 28, 2), 'F_Tbl_Out4': datetime.datetime(2020,
    7, 11, 15, 41, 25), 'F_Tbl_CrDate': datetime.datetime(2020, 7, 11, 14, 50, 59), 'F_Tbl_In1': datetime.datetime(
    2020, 7, 11, 15, 41, 25), 'F_Tbl_Outtm': datetime.datetime(2020, 7, 11, 15, 41, 25), 'F_Tbl_MoBy': 'MI',
    'F_Tbl_Out1': datetime.datetime(2020, 7, 11, 15, 41, 25), 'F_Tbl_Sh_Code': None, 'F_Tbl_MoDate':
    datetime.datetime(2020, 7, 11, 14, 50, 59), 'F_Tbl_row_id': 4137290254, 'F_Tbl_In2': datetime.datetime(2020, 7,
    11, 15, 41, 25), 'F_Tbl_Verified': b'\x00', 'F_Tbl_SentToOracle': None, 'F_Tbl_Emp_Code': '2271', 'F_Tbl_Out2':
    datetime.datetime(2020, 7, 11, 15, 41, 25), 'F_Tbl_WorkHours': None, 'F_Tbl_P_TIME': datetime.datetime(2020, 7,
    10, 14, 50, 59), 'F_Tbl_In3': datetime.datetime(2020, 7, 11, 15, 41, 25), 'F_Tbl_ShiftHours': None, 'F_Tbl_Out3':
    datetime.datetime(2020, 7, 11, 15, 41, 25)}

    """
    found = False
    punchTime = date.today()
    id = "2271"
    found, row = msserver_obj.getpunchDateData(id)
    print(found, row)
    return found, row


def main():
    """main function
    """
    msserver_obj = create_db_obj()  # Vamshi
    mongo_obj = init_mongo()  # Sid
    # fetch data from mongo
    data = fetch_from_mongo(mongo_obj)  # Sid
    # get shift window
    data = get_shift_window(data, msserver_obj)  # aggregating information #Vamshi
    # filter records
    data = filter_records(data)  # Sid
    # insert employee records
    insert_data(data, msserver_obj)  # Insert/Update #Vamshi


msserver_obj = create_db_obj()
get_config(msserver_obj)
# print(msserver_obj)
get_shift_window(msserver_obj,"",'')
# insert_data("", msserver_obj)
# get_data_for_punch_date(msserver_obj, "", "")
# mongo = PullEvents()
# indshift(msserver_obj)
empid = "1"
timestamps = [datetime.today(), datetime.today() + timedelta(days=1)]
# mongo.create_event_records(empid, timestamps)
# print(del_employee_for_punch_date(msserver_obj,'',''))
# data = get_shift_window(data, msserver_obj)
# if __name__ == '__main__':
#     MYSQL_CONFIG = MONGO_DB_OBJ[MONGO_SERVICE_COLL].find_one({'configId': 'mysqlDB'}).get('config')
#     pull_events = PullEvents()
#     sql_h = SQLiteHandler()
#     from_time = datetime.strptime(MYSQL_CONFIG['last_pull_from'], '%Y-%m-%d %H:%M:%S') + timedelta(hours=1)
#     to_time = datetime.strptime(MYSQL_CONFIG['last_pull_to'], '%Y-%m-%d %H:%M:%S') + timedelta(hours=1)
#     events = pull_events.get_attendance(
#         from_time=from_time,
#         to_time=to_time
#     )
#     logger.info("Collected {} Records".format(len(events)))
#     for item in events:
#         sql_h.add_event_to_db(item)
#     # update the last pull time
#     MONGO_DB_OBJ[MONGO_SERVICE_COLL].update_one({'configId': 'mysqlDB'}, {
#         "$set": {"config.last_pull_from": from_time.strftime("%Y-%m-%d %H:%M:%S"),
#                  "config.last_pull_to": to_time.strftime("%Y-%m-%d %H:%M:%S")}})
#
#     logger.info("Data load Complete..")
#     logger.info("{}, {}".format(from_time, to_time))
