from dateutil import parser
from loguru import logger

from scripts.constants.app_configuration import MONGO_URI
from scripts.core.db.model_catalog import ModelCatalogCollection
from scripts.utils.mongo_util import MongoConnect


class Pipeline:
    def __init__(self, project_id=None):
        self.mongo_client = MongoConnect(uri=MONGO_URI)()
        self.project_id = project_id

    def get_model_catalog_data(self, model_catalog_id):
        logger.info(f"Getting Data for model catalog id: {model_catalog_id}")
        model_catalog_collection = ModelCatalogCollection(
            mongo_client=self.mongo_client, project_id=self.project_id
        )
        return model_catalog_collection.get_one_model_catalog(model_id=model_catalog_id)

    def parse_model_data(self, data, model_catalog_id):
        basic_info = data["basic_info"]
        process_name = basic_info["process_name"]
        stage_name = basic_info["stage_name"]
        logger.info(f"Process Name: {process_name} and Stage Name: {stage_name}")
        start_time = None
        end_time = None
        for i in data["criteria"]["args"]:
            if i["key"] == "date_from":
                start_time = i["value"]
            elif i["key"] == "date_to":
                end_time = i["value"]
        logger.info(f"Start time: {start_time}, end time: {end_time}")
        start_time = parser.parse(start_time).timestamp() * 1000
        end_time = parser.parse(end_time).timestamp() * 1000
        return {
            "process_name": process_name,
            "stage_name": stage_name,
            "start_time": int(start_time),
            "end_time": int(end_time),
        }

    def get_meta_data(self, model_id):
        model_data = self.get_model_catalog_data(model_catalog_id=model_id)
        model_data_dict = self.parse_model_data(model_data, model_id)
        return model_data_dict
