from uuid import uuid4

from scripts.constants.app_constants import DBConstants
from scripts.utils.mongo_util import MongoCollectionBaseClass


class ModelCatalogCollection(MongoCollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(
            mongo_client,
            database=DBConstants.db_ilens_yield_optimizer,
            collection=DBConstants.collection_yield_model_catalog,
        )
        self.project_id = project_id

    def save_model(self, data: dict):
        if data.get("id") is None:
            data["id"] = str(uuid4())
        self.update_one(query={"id": data.get("id")}, data=data, upsert=True)
        return {"id": data.get("id")}

    def partial_update_model(self, model_id, data: dict):
        # todo update meta also.
        self.update_one(query={"id": model_id}, data=data)
        return id

    def get_one_model_catalog(self, model_id):
        return self.find_one(query={"id": model_id})
