from loguru import logger

from scripts.utils.pipeline_util import Pipeline


class RawMaterialOptimization:
    def __init__(self, model_id):
        logger.info("Starting the Module")
        self.pipeline_obj = Pipeline()
        self.model_id = model_id

    def build_model(self):
        model_data = self.pipeline_obj.get_meta_data(self.model_id)
        print(model_data)
        return model_data


if __name__ == "__main__":
    model_catalog_id = "01595870-f91a-4db0-abfa-28efe60b219c"
    __rmo = RawMaterialOptimization(model_catalog_id)
    __rmo.build_model()
